﻿using Android.App;
using Android.Content;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;

namespace Uslugi
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private Button button1, button2;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            Xamarin.Essentials.Platform.Init(this, savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            button1 = FindViewById<Button>(Resource.Id.button1);
            button2 = FindViewById<Button>(Resource.Id.button2);

            button1.Click += (sender, args) =>
            {
                if (Usluga.czyUtworzona)
                    return;

                Toast.MakeText(this, "Uruchamiam usluge", ToastLength.Short).Show();
                StartService(new Intent(this, typeof(Usluga)));
            };

            button2.Click += (sender, args) =>
            {
                if (!Usluga.czyUtworzona)
                    return;

                Toast.MakeText(this, "Zatrzymuje usluge", ToastLength.Short).Show();
                StopService(new Intent(this, typeof(Usluga)));
            };

        }
        public override void OnRequestPermissionsResult(int requestCode, string[] permissions, [GeneratedEnum] Android.Content.PM.Permission[] grantResults)
        {
            Xamarin.Essentials.Platform.OnRequestPermissionsResult(requestCode, permissions, grantResults);

            base.OnRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }
}