﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Windows;

using Umk.Ntpp;

namespace TcpWindows
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private NtppClient ntppClient;

        public MainWindow()
        {
            InitializeComponent();

            ntppClient = new NtppClient(Environment.MachineName);
            ntppClient.StateChanged += ntppClient_StateChanged;
            ntppClient.TextReceived += ntppClient_TextReceived;
            ntppClient.DeviceFound += ntppClient_DeviceFound;
        }

        private void ntppClient_StateChanged(object sender, NtppClient.StateChangedEventArgs e)
        {
            Action a = () => { tbStan.Text = e.NewState.ToString(); };
            if (!Dispatcher.CheckAccess()) Dispatcher.Invoke(a); else a();
        }

        private void ntppClient_TextReceived(object sender, NtppClient.TextReceivedEventArgs e)
        {
            Action a = () => { lbOdebraneKomunikaty.Items.Add(e.ReceivedFrom.Hostname.ToString() + " (" + DateTime.Now.ToString() + "): " + e.ReceivedText); };
            if (!Dispatcher.CheckAccess()) Dispatcher.Invoke(a); else a();
        }

        private void ntppClient_DeviceFound(object sender, NtppClient.DeviceFoundArgs e)
        {
            Action a = () =>
            {
                string value = e.Name + " (" + e.IpAddress.ToString() + ")";

                if (!lvDevices.Items.Contains(value))
                {
                    lvDevices.Items.Add(value);
                    Debug.WriteLine("{0} {1}", e.Name, e.IpAddress);
                }
            };

            if (!Dispatcher.CheckAccess()) Dispatcher.Invoke(a); else a();
        }

        private void btnPolacz_Click(object sender, RoutedEventArgs e)
        {
            if (lvDevices.Items.Count == 0)
            {
                MessageBox.Show("Nie znaleziono żadnych urządzeń", "Błąd", MessageBoxButton.OK, MessageBoxImage.Error);
                return;
            }

            if (lvDevices.SelectedIndex == -1)
            {
                MessageBox.Show("Nie wybrano żadnego urządzenia z listy", "Błąd", MessageBoxButton.OK, MessageBoxImage.Error);
                return;
            }

            string selectedItem = (string) lvDevices.Items[lvDevices.SelectedIndex];
            int addrStartIndex = selectedItem.IndexOf("(");
            int addrEndIndex = selectedItem.IndexOf(")");
            string address = selectedItem.Substring(addrStartIndex + 1, addrEndIndex - addrStartIndex - 1);

            NtppConnectionData connectionData = new NtppConnectionData()
            {
                Hostname = address
            };
            ntppClient.WaitForConnection(connectionData);
        }

        private void btnRozlacz_Click(object sender, RoutedEventArgs e)
        {
            ntppClient.Disconnect();
        }

        private void btnWyslij_Click(object sender, RoutedEventArgs e)
        {
            ntppClient.SendText(tbTekst.Text);
        }

        private void Window_Closed(object sender, EventArgs e)
        {
            btnRozlacz_Click(this, null);

            ntppClient.StateChanged -= ntppClient_StateChanged;
            ntppClient.TextReceived -= ntppClient_TextReceived;
            ntppClient.DeviceFound -= ntppClient_DeviceFound;
        }
    }
}
