﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using Android.Graphics;
using Android.Graphics.Drawables.Shapes;
using Android.Graphics.Drawables;
using Android.Content;
using Android.Preferences;
using System;
using System.Globalization;
using Android.Util;
using Android.Views;

namespace Kolory
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private TextView etykieta_panel;
        private SeekBar seekBarR, seekBarG, seekBarB;
        private SeekBar seekBarH, seekBarS, seekBarV;
        private Spinner spinner;
        private Button resetButton;
        private View mainLayout;
        private bool flaga, RGBflag, HSVflag;
        IFormatProvider formatProvider;
        private float[] promienie;
        private int[] gradient;
        private RoundRectShape rrs;
        private ShapeDrawable sdR, sdG, sdB, sdH, sdS, sdV;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            formatProvider = CultureInfo.InvariantCulture;

            float promień = 16;
            promienie = new float[] { promień, promień, promień, promień, promień, promień, promień, promień };
            rrs = new RoundRectShape(promienie, null, null);
            gradient = new int[7];
            gradient[0] = Color.Argb(255, 255, 0, 0);
            gradient[1] = Color.Argb(255, 255, 255, 0);
            gradient[2] = Color.Argb(255, 0, 255, 0);
            gradient[3] = Color.Argb(255, 0, 255, 255);
            gradient[4] = Color.Argb(255, 0, 0, 255);
            gradient[5] = Color.Argb(255, 255, 0, 255);
            gradient[6] = Color.Argb(255, 255, 0, 0);

            base.OnCreate(savedInstanceState);
            SetContentView(Resource.Layout.activity_main);

            etykieta_panel = FindViewById<TextView>(Resource.Id.etykieta_panel);
            resetButton = FindViewById<Button>(Resource.Id.resetButton);
            seekBarR = FindViewById<SeekBar>(Resource.Id.seekBarR);
            seekBarG = FindViewById<SeekBar>(Resource.Id.seekBarG);
            seekBarB = FindViewById<SeekBar>(Resource.Id.seekBarB);
            seekBarH = FindViewById<SeekBar>(Resource.Id.seekBarH);
            seekBarS = FindViewById<SeekBar>(Resource.Id.seekBarS);
            seekBarV = FindViewById<SeekBar>(Resource.Id.seekBarV);
            spinner = FindViewById<Spinner>(Resource.Id.spinner);

            resetButton.Click += resetButton_OnButtonClicked;
            seekBarR.ProgressChanged += seekBarRGB_ProgressChanged;
            seekBarG.ProgressChanged += seekBarRGB_ProgressChanged;
            seekBarB.ProgressChanged += seekBarRGB_ProgressChanged;
            seekBarH.ProgressChanged += seekBarHSV_ProgressChanged;
            seekBarS.ProgressChanged += seekBarHSV_ProgressChanged;
            seekBarV.ProgressChanged += seekBarHSV_ProgressChanged;
            spinner.ItemSelected += spinner_ItemSelected;

            mainLayout = FindViewById<View>(Resource.Id.mainLayout);
            mainLayout.ViewTreeObserver.GlobalLayout += (sender, args) =>
            {
                sdR = new ShapeDrawable(rrs);
                sdR.Paint.SetShader(new LinearGradient(0, 0, 400, 0, Color.White, Color.Red, Shader.TileMode.Clamp));
                seekBarR.ProgressDrawable = sdR;

                sdG = new ShapeDrawable(rrs);
                sdG.Paint.SetShader(new LinearGradient(0, 0, 400, 0, Color.White, Color.Green, Shader.TileMode.Clamp));
                seekBarG.ProgressDrawable = sdG;

                sdB = new ShapeDrawable(rrs);
                sdB.Paint.SetShader(new LinearGradient(0, 0, 400, 0, Color.White, Color.Blue, Shader.TileMode.Clamp));
                seekBarB.ProgressDrawable = sdB;

                sdH = new ShapeDrawable(rrs);
                sdH.Paint.SetShader(new LinearGradient(0, 0, seekBarH.Width, 0, gradient, null, Shader.TileMode.Clamp));
                seekBarH.ProgressDrawable = sdH;

                sdS = new ShapeDrawable(rrs);
                sdS.Paint.SetShader(new LinearGradient(0, 0, seekBarS.Width / 2, 0, Color.White, (Color.HSVToColor(new[] { seekBarH.Progress, 1.0f, 1.0f })), Shader.TileMode.Clamp));
                seekBarS.ProgressDrawable = sdS;

                sdV = new ShapeDrawable(rrs);
                sdV.Paint.SetShader(new LinearGradient(0, 0, seekBarV.Width / 2, 0, Color.Black, (Color.HSVToColor(new[] { seekBarH.Progress, (seekBarS.Progress / 100.0f), 1.0f })), Shader.TileMode.Clamp));
                seekBarV.ProgressDrawable = sdV;
            };

            ArrayAdapter adapter = ArrayAdapter.CreateFromResource(this, Resource.Array.kolory, Android.Resource.Layout.SimpleSpinnerItem);
            adapter.SetDropDownViewResource(Android.Resource.Layout.SimpleSpinnerDropDownItem);
            spinner.Adapter = adapter;

            odtwórzStan();
        }

        private void RedrawSeekBars()
        {
            sdR.Paint.SetShader(new LinearGradient(0, 0, 400, 0, Color.White, Color.Red, Shader.TileMode.Clamp));
            seekBarR.ProgressDrawable = sdR;

            sdG.Paint.SetShader(new LinearGradient(0, 0, 400, 0, Color.White, Color.Green, Shader.TileMode.Clamp));
            seekBarG.ProgressDrawable = sdG;

            sdB.Paint.SetShader(new LinearGradient(0, 0, 400, 0, Color.White, Color.Blue, Shader.TileMode.Clamp));
            seekBarB.ProgressDrawable = sdB;

            sdH.Paint.SetShader(new LinearGradient(0, 0, seekBarH.Width, 0, gradient, null, Shader.TileMode.Clamp));
            seekBarH.ProgressDrawable = sdH;

            sdS.Paint.SetShader(new LinearGradient(0, 0, seekBarS.Width / 2, 0, Color.White, (Color.HSVToColor(new[] { seekBarH.Progress, 1.0f, 1.0f })), Shader.TileMode.Clamp));
            seekBarS.ProgressDrawable = sdS;

            sdV.Paint.SetShader(new LinearGradient(0, 0, seekBarV.Width / 2, 0, Color.Black, (Color.HSVToColor(new[] { seekBarH.Progress, (seekBarS.Progress / 100.0f), 1.0f })), Shader.TileMode.Clamp));
            seekBarV.ProgressDrawable = sdV;
        }

        private void resetButton_OnButtonClicked(object sender, EventArgs e)
        {
            seekBarR.Progress = 50;
            seekBarG.Progress = 50;
            seekBarB.Progress = 50;
        }

        private void spinner_ItemSelected(object sender, AdapterView.ItemSelectedEventArgs e)
        {
            flaga = false;
            switch (e.Position)
            {
                case 0:
                    spinner.SetSelection(0);
                    break;
                case 1: // Czarny
                    seekBarR.Progress = 0;
                    seekBarG.Progress = 0;
                    seekBarB.Progress = 0;
                    break;
                case 2: // Biały
                    seekBarR.Progress = 255;
                    seekBarG.Progress = 255;
                    seekBarB.Progress = 255;
                    break;
                case 3: // Czerwony
                    seekBarR.Progress = 255;
                    seekBarG.Progress = 0;
                    seekBarB.Progress = 0;
                    break;
                case 4: // Zielony
                    seekBarR.Progress = 0;
                    seekBarG.Progress = 255;
                    seekBarB.Progress = 0;
                    break;
                case 5: // Niebieski
                    seekBarR.Progress = 0;
                    seekBarG.Progress = 0;
                    seekBarB.Progress = 255;
                    break;
                case 6: // Turkusowy
                    seekBarR.Progress = 0;
                    seekBarG.Progress = 255;
                    seekBarB.Progress = 255;
                    break;
                case 7: // Purpurowy
                    seekBarR.Progress = 255;
                    seekBarG.Progress = 0;
                    seekBarB.Progress = 255;
                    break;
                case 8: // Żółty
                    seekBarR.Progress = 255;
                    seekBarG.Progress = 255;
                    seekBarB.Progress = 0;
                    break;
                case 9: // Szary
                    seekBarR.Progress = 128;
                    seekBarG.Progress = 128;
                    seekBarB.Progress = 128;
                    break;
            }
            RedrawSeekBars();
            flaga = true;
        }

        private void seekBarRGB_ProgressChanged(object sender, SeekBar.ProgressChangedEventArgs e)
        {
            RGBflag = true;

            int r = seekBarR.Progress;
            int g = seekBarG.Progress;
            int b = seekBarB.Progress;

            float[] hsvComponent = { 0f, 0f, 0f };
            Color.RGBToHSV(r, g, b, hsvComponent);

            if (!HSVflag)
            {
                seekBarH.Progress = (int)hsvComponent[0];
                seekBarS.Progress = (int)(hsvComponent[1] * 100);
                seekBarV.Progress = (int)(hsvComponent[2] * 100);
            }

            string rgb = "#" +
                r.ToString("X2").ToUpper() +
                g.ToString("X2").ToUpper() +
                b.ToString("X2").ToUpper();
            string hsv = System.Math.Round(hsvComponent[0]).ToString(formatProvider) + " ; " +
                         System.Math.Round(hsvComponent[1], 2).ToString(formatProvider) + " ; " +
                         System.Math.Round(hsvComponent[2], 2).ToString(formatProvider);

            etykieta_panel.SetBackgroundColor(Color.Argb(255, r, g, b));
            etykieta_panel.Text = this.GetString(Resource.String.etykieta) + "\n" + "RGB: " + rgb + "\nHSV: " + hsv;

            int jasność = (int)(0.2*r + 0.7*g + 0.1*b);
            etykieta_panel.SetTextColor((jasność > 127) ? Color.Black : Color.White);

            if (flaga)
                spinner.SetSelection(0);

            RGBflag = false;
        }

        private void seekBarHSV_ProgressChanged(object sender, SeekBar.ProgressChangedEventArgs e)
        {
            HSVflag = true;

            float h = seekBarH.Progress;
            float s = seekBarS.Progress;
            float v = seekBarV.Progress;

            int r, g, b;

            float[] rgbComponent = { h, s / 100.0f, v / 100.0f };
            Color rgbValues = Color.HSVToColor(rgbComponent);
            r = rgbValues.R;
            g = rgbValues.G;
            b = rgbValues.B;

            if (!RGBflag)
            {
                seekBarR.Progress = r;
                seekBarG.Progress = g;
                seekBarB.Progress = b;
            }

            string rgb = "#" +
                r.ToString("X2").ToUpper() +
                g.ToString("X2").ToUpper() +
                b.ToString("X2").ToUpper();
            string hsv = h.ToString(formatProvider) + " ; " + (s / 100.0f).ToString(formatProvider) + " ; " + (h / 100.0f).ToString(formatProvider);

            etykieta_panel.SetBackgroundColor(Color.Argb(255, r, g, b));
            etykieta_panel.Text = this.GetString(Resource.String.etykieta) + "\n" + "RGB: " + rgb + "\nHSV: " + hsv;

            int jasność = (int)(0.2 * r + 0.7 * g + 0.1 * b);
            etykieta_panel.SetTextColor((jasność > 127) ? Color.Black : Color.White);

            if (flaga)
                spinner.SetSelection(0);

            HSVflag = false;
        }

        private const string składowaR = "SkładowaR";
        private const string składowaG = "SkładowaG";
        private const string składowaB = "SkładowaB";

        private void zapiszStan()
        {
            ISharedPreferencesEditor edytorUstawień = PreferenceManager.GetDefaultSharedPreferences(this).Edit();
            edytorUstawień.PutInt(składowaR, seekBarR.Progress);
            edytorUstawień.PutInt(składowaG, seekBarG.Progress);
            edytorUstawień.PutInt(składowaB, seekBarB.Progress);
            edytorUstawień.Commit();
        }

        private bool odtwórzStan()
        {
            ISharedPreferences ustawienia = PreferenceManager.GetDefaultSharedPreferences(this);
            seekBarR.Progress = ustawienia.GetInt(składowaR, 0);
            seekBarG.Progress = ustawienia.GetInt(składowaG, 0);
            seekBarB.Progress = ustawienia.GetInt(składowaB, 0);
            if (ustawienia.Contains(składowaR) && ustawienia.Contains(składowaG) && ustawienia.Contains(składowaB))
                return true;
            else
                return false;
        }

        protected override void OnPause()
        {
            base.OnPause();
            zapiszStan();
        }
    }
}