﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;

namespace BazaDanychSqlLite
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private void pokażOsoby(Osoba[] osoby)
        {
            string s = "Rekordy:";
            foreach (Osoba osoba in osoby)
                s += "\n" + osoba.ToString();
            TextView tv = FindViewById<TextView>(Resource.Id.textView);
            tv.Text = s;
        }

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            //usunięcie
            this.DeleteDatabase(BazaDanychOsob.NazwaBazyDanych);

            //tworzenie
            BazaDanychOsob dbm = new BazaDanychOsob(this);
            dbm.DodajRekord(new Osoba(1, "Jan", "Kowalski", 45, 3423478));
            dbm.DodajRekord(new Osoba(3, "Hans", "Muller", 32, 83427534));
            dbm.DodajRekord(new Osoba(2, "John", "Smith", 36, 87378434));            

            //odczyt
            Osoba[] osoby = dbm.PobierzWszystkieRekordy("Wiek desc");
            pokażOsoby(osoby);

            dbm.UsuńRekord(2);

            //osoby = dbm.PobierzWszystkieRekordy();
            //pokażOsoby(osoby);

            dbm.ZmieńRekord(1, new Osoba(4, "Jean", "Dupont", 50, 237498273));

            osoby = dbm.PobierzWszystkieRekordy();
            pokażOsoby(osoby);

            //XML
            string nazwaPlikuXml = "osoby.xml";

            try
            {
                PlikXml.ZapiszOsobyDoPlikuXml(this, osoby, nazwaPlikuXml);
                Toast.MakeText(this, "Plik XML został zapisany", ToastLength.Short).Show();

            }
            catch(Java.IO.IOException exc)
            {
                Toast.MakeText(this, "A: " + exc.Message, ToastLength.Short).Show();
            }
            catch (System.IO.IOException exc)
            {
                Toast.MakeText(this, "N: " + exc.Message, ToastLength.Short).Show();
            }
            catch(Java.Lang.Exception exc)
            {
                Toast.MakeText(this, "A: " + exc.Message, ToastLength.Short).Show();
            }
            catch (System.Exception exc)
            {
                Toast.MakeText(this, "N: " + exc.Message, ToastLength.Short).Show();
            }

            try
            {
                //Osoba[] _osoby = PlikXml.CzytajOsobyZPlikuXml(this, nazwaPlikuXml);
                Osoba[] _osoby = null;
                Java.Lang.Thread thread = new Java.Lang.Thread(
                    () =>
                    {
                        //od Android 9.0 dozwolone tylko HTTPS
                        _osoby = PlikXml.CzytajOsobyZPlikuXml(new Java.Net.URL("https://fizyka.umk.pl/~jacek/dydaktyka/mobilne/2019L_KLUCZ/osoby.xml"));
                    });
                thread.Start();
                thread.Join();
                pokażOsoby(_osoby);
            }
            catch(Org.W3c.Dom.DOMException exc)
            {
                Toast.MakeText(this, "Błąd odczytu: " + exc.Message, ToastLength.Short).Show();
            }
            catch (Java.Lang.Exception exc)
            {
                Toast.MakeText(this, "Ogólny błąd odczytu: " + exc.Message, ToastLength.Short).Show();
            }
        }
    }
}