﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;

using Android.Content;
using Android.Database.Sqlite;
using Android.Database;

namespace BazaDanychSqlLite
{
    public class Osoba
    {        
        public const string NazwaTabeli = "osoba";
        public static readonly string[] NazwyKolumnTabeli = { "Id", "Imię", "Nazwisko", "Wiek", "NumerTelefonu" };
        public static readonly string[] WłasnościKolumnTabeli = { "INTEGER PRIMARY KEY", "TEXT", "TEXT", "INTEGER", "INTEGER" };

        public int Id;
        public string Imię;
        public string Nazwisko;
        public int Wiek;
        public int NumerTelefonu;

        public Osoba(int id, string imię, string nazwisko, int wiek, int numerTelefonu)
        {
            this.Id = id;
            this.Imię = imię;
            this.Nazwisko = nazwisko;
            this.Wiek = wiek;
            this.NumerTelefonu = numerTelefonu;
        }

        public override string ToString()
        {
            return "(" + Id.ToString() + ") " + Imię + " " + Nazwisko + " (" + Wiek + "), tel. " + NumerTelefonu.ToString();
        }
    }

    public class BazaDanychOsob : SQLiteOpenHelper
    {
        public const string NazwaBazyDanych = "osoby.db";

        public BazaDanychOsob(Context context) : 
            base(context, NazwaBazyDanych, null, 1)
        {
        }

        public override void OnCreate(SQLiteDatabase db)
        {
            //tworzy bazę danych
            //lepiej użyć StringBuildera
            string createCommand = "create table " + Osoba.NazwaTabeli + " (";
            for(int numerKolumny = 0; numerKolumny < Osoba.NazwyKolumnTabeli.Length; ++ numerKolumny)
            {
                string nazwaKolumny = Osoba.NazwyKolumnTabeli[numerKolumny];
                string własnościKolumny = Osoba.WłasnościKolumnTabeli[numerKolumny];
                createCommand += nazwaKolumny + " " + własnościKolumny + ",";
            }
            createCommand = createCommand.TrimEnd(',');
            createCommand += ")";
            db.ExecSQL(createCommand);
        }

        public override void OnUpgrade(SQLiteDatabase db, int oldVersion, int newVersion)
        {
            //zmieniamy wersję
        }

        private static ContentValues wartościZOsoby(Osoba osoba)
        {
            ContentValues wartości = new ContentValues();
            wartości.Put(Osoba.NazwyKolumnTabeli[0], osoba.Id);
            wartości.Put(Osoba.NazwyKolumnTabeli[1], osoba.Imię);
            wartości.Put(Osoba.NazwyKolumnTabeli[2], osoba.Nazwisko);
            wartości.Put(Osoba.NazwyKolumnTabeli[3], osoba.Wiek);
            wartości.Put(Osoba.NazwyKolumnTabeli[4], osoba.NumerTelefonu);
            return wartości;
        }

        public void DodajRekord(Osoba osoba)
        {
            ContentValues wartości = wartościZOsoby(osoba);
            SQLiteDatabase db = this.WritableDatabase;
            db.InsertOrThrow(Osoba.NazwaTabeli, null, wartości);
        }

        private static Osoba osobaZKaretki(ICursor karetka)
        {
            Osoba osoba = new Osoba(
                karetka.GetInt(0),
                karetka.GetString(1),
                karetka.GetString(2),
                karetka.GetInt(3),
                karetka.GetInt(4));
            return osoba;
        }

        public Osoba[] PobierzWszystkieRekordy(string orderBy)
        {
            SQLiteDatabase db = this.ReadableDatabase;
            ICursor karetka = db.Query(
                Osoba.NazwaTabeli, Osoba.NazwyKolumnTabeli,
                null, null, null, null,
                orderBy);
            List<Osoba> lista = new List<Osoba>();
            while(karetka.MoveToNext())
            {
                lista.Add(osobaZKaretki(karetka));
            }
            karetka.Close();
            Osoba[] tablica = lista.ToArray();
            return tablica;
        }

        public Osoba[] PobierzWszystkieRekordy()
        {
            return PobierzWszystkieRekordy(null);
        }

        //CRUD
        public Osoba PobierzRekord(int id)
        {
            SQLiteDatabase db = this.ReadableDatabase;
            Osoba osoba = PobierzWszystkieRekordy().Single(o => o.Id == id);
            return osoba;
        }

        public bool UsuńRekord(int id)
        {
            SQLiteDatabase db = this.WritableDatabase;
            string[] whereArgs = { id.ToString() };
            return db.Delete(Osoba.NazwaTabeli, "Id=?", whereArgs) > 0;
        }

        public bool ZmieńRekord(int id, Osoba osoba)
        {
            SQLiteDatabase db = this.WritableDatabase;
            ContentValues wartości = wartościZOsoby(osoba);
            string[] whereArgs = { id.ToString() };
            return db.Update(Osoba.NazwaTabeli, wartości, "Id=?", whereArgs) > 0;
        }
    }
}