﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;

namespace BazaDanychSqlLite
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private void pokażOsoby(Osoba[] osoby)
        {
            string s = "Rekordy:";
            foreach (Osoba osoba in osoby)
                s += "\n" + osoba.ToString();
            TextView tv = FindViewById<TextView>(Resource.Id.textView);
            tv.Text = s;
        }

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            //usunięcie
            this.DeleteDatabase(BazaDanychOsob.NazwaBazyDanych);

            //tworzenie
            BazaDanychOsob dbm = new BazaDanychOsob(this);
            dbm.DodajRekord(new Osoba(1, "Jan", "Kowalski", 45, 3423478));
            dbm.DodajRekord(new Osoba(3, "Hans", "Muller", 32, 83427534));
            dbm.DodajRekord(new Osoba(2, "John", "Smith", 36, 87378434));            

            //odczyt
            Osoba[] osoby = dbm.PobierzWszystkieRekordy("Wiek desc");
            pokażOsoby(osoby);

            dbm.UsuńRekord(2);

            //osoby = dbm.PobierzWszystkieRekordy();
            //pokażOsoby(osoby);

            dbm.ZmieńRekord(1, new Osoba(4, "Jean", "Dupont", 50, 237498273));

            osoby = dbm.PobierzWszystkieRekordy();
            pokażOsoby(osoby);
        }
    }
}