﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.Media;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;

namespace Uslugi
{
    [Service]
    class Usluga : Service
    {
        public override IBinder OnBind(Intent intent)
        {
            return null;
        }

        public static bool CzyUtworzona { get; private set; } = false;

        private Java.Util.Timer timer;
        private static Toast toastDlaTimera;

        private static ToneGenerator tg = new ToneGenerator(Stream.Alarm, 100);

        class Zadanie : Java.Util.TimerTask
        {
            public override void Run()
            {
                string czas = DateTime.Now.ToLongTimeString();
                //toastDlaTimera.SetText("Usługa: " + czas);
                //toastDlaTimera.Show();                
                tg.StartTone(Tone.CdmaAlertCallGuard, 200);
            }
        }

        public override void OnCreate()
        {
            base.OnCreate();

            Notification.Builder nb;
            Notification powiadomienie;

            if(Build.VERSION.SdkInt >= BuildVersionCodes.O)
            {
                NotificationManager nm = (NotificationManager)GetSystemService(NotificationService);
                nm.CreateNotificationChannel(new NotificationChannel("usluga", "usluga", NotificationImportance.Low));
                nb = new Notification.Builder(this, "usluga");
            }
            else
            {
                nb = new Notification.Builder(this);
            }

            Intent i = new Intent(this, typeof(MainActivity));
            PendingIntent pi = PendingIntent.GetActivity(this, 0, i, 0);

            nb.SetContentTitle("Usluga");
            nb.SetContentText("Usluga dziala w tle");
            nb.SetContentIntent(pi);
            nb.SetSmallIcon(Resource.Mipmap.ic_launcher_foreground);

            powiadomienie = nb.Build();

            StartForeground(12, powiadomienie);

            //+ poprosić o wyłączenie optymalizacji zużycia baterii dla tej aplikacji

            toastDlaTimera = Toast.MakeText(this, "", ToastLength.Short);

            timer = new Java.Util.Timer();
            timer.ScheduleAtFixedRate(new Zadanie(), 1000, 2000);

            CzyUtworzona = true;
            Toast.MakeText(this, "Usługa utworzona", ToastLength.Short).Show();
        }

        public override void OnDestroy()
        {            
            timer.Cancel();
            CzyUtworzona = false;
            Toast.MakeText(this, "Usługa zatrzymana", ToastLength.Short).Show();
            base.OnDestroy();            
        }

        [return: GeneratedEnum]
        public override StartCommandResult OnStartCommand(Intent intent, [GeneratedEnum] StartCommandFlags flags, int startId)
        {
            Toast.MakeText(this, "Usługa uruchomiona", ToastLength.Short).Show();
            return base.OnStartCommand(intent, flags, startId);
        }
    }
}