﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using Android.Views;

namespace Pierscien
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private void pokażToast(string komunikat)
        {
            RunOnUiThread(() => { Toast.MakeText(this, komunikat, ToastLength.Short).Show(); });
        }


        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            /*
            //nie działa tak, jak chcemy
            Java.Lang.Thread.Sleep(5000);
            Toast.MakeText(this, "Inicjacja zakończona", ToastLength.Short).Show();

            View panelPiersienia = FindViewById(Resource.Id.panelPierscienia);
            panelPiersienia.Visibility = ViewStates.Gone;
            Toast.MakeText(this, "Panel pierścienia ukryty", ToastLength.Short).Show();
            */

            Java.Lang.Thread t = new Java.Lang.Thread(
                () =>
                {
                    try
                    {
                        Java.Lang.Thread.Sleep(5000);
                        pokażToast("Inicjacja zakończona");
                    }
                    catch (Java.Lang.InterruptedException)
                    {
                        pokażToast("Inicjacja przerwana");
                    }
                    finally
                    {
                        RunOnUiThread(
                            () =>
                            {
                                View panelPiersienia = FindViewById(Resource.Id.panelPierscienia);
                                panelPiersienia.Visibility = ViewStates.Gone;
                                Toast.MakeText(this, "Panel pierścienia ukryty", ToastLength.Short).Show();
                            });
                    }
                });

            t.Start();
        }
    }
}