﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using Android.Content;

namespace Powiadomienia
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private EditText etTytuł, etTreść;
        private Button btnPokaż, btnUkryj;
        private const int idPowiadomienia = 0;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            etTytuł = FindViewById<EditText>(Resource.Id.tytul);
            etTreść = FindViewById<EditText>(Resource.Id.tresc);

            btnPokaż = FindViewById<Button>(Resource.Id.pokaz);
            btnUkryj = FindViewById<Button>(Resource.Id.ukryj);

            btnPokaż.Click += BtnPokaż_Click;
            btnUkryj.Click += BtnUkryj_Click;
        }

        private void BtnPokaż_Click(object sender, System.EventArgs e)
        {
            Toast.MakeText(this, etTreść.Text, ToastLength.Long).Show();

            Intent i = new Intent(this, typeof(MainActivity));
            PendingIntent pi = PendingIntent.GetActivity(this, 0, i, 0);

            NotificationManager nm = (NotificationManager)GetSystemService(NotificationService);

            //API > 26
            //string channelId = "kanał";
            //nm.CreateNotificationChannel(new NotificationChannel(channelId, "Kanał UMK", NotificationImportance.Default));

            Notification.Builder nb = new Notification.Builder(this);
            //Notification.Builder nb = new Notification.Builder(this, channelId);
            nb.SetSmallIcon(Resource.Mipmap.ic_launcher);
            nb.SetContentTitle(etTytuł.Text);
            nb.SetContentText(etTreść.Text);
            nb.SetContentIntent(pi);
            //nb.AddAction(Resource.Mipmap.ic_launcher, "Uruchom", pi);

            Notification n = nb.Build();
            n.Flags |= NotificationFlags.AutoCancel;

            nm.Notify(idPowiadomienia, n);
        }

        private void BtnUkryj_Click(object sender, System.EventArgs e)
        {
            NotificationManager nm = (NotificationManager)GetSystemService(NotificationService);
            nm.Cancel(idPowiadomienia);
        }
    }
}