﻿//using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.Database;
using Android.Net;
using Android.OS;
using Android.Provider;
using Android.Runtime;
using Android.Views;
using Android.Widget;

namespace JacekMatulewski.Android
{

    //klasa encji
    public class Kontakt
    {
        public string NazwaWyświetlana;
        public string TelefonKomórkowy;
        public string TelefonDomowy;
        public string TelefonWPracy;
        public string EmailWPracy;
        public string Firma;
        public string Tytuł;
        //można uzupełnić o zdjęcie

        public Kontakt(
            string nazwaWyświetlana,
            string telefonKomórkowy,
            string telefonDomowy,
            string telefonWPracy,
            string emailWPracy,
            string firma,
            string tytuł)
        {
            this.NazwaWyświetlana = nazwaWyświetlana;
            this.TelefonKomórkowy = telefonKomórkowy;
            this.TelefonDomowy = telefonDomowy;
            this.TelefonWPracy = telefonWPracy;
            this.EmailWPracy = emailWPracy;
            this.Firma = firma;
            this.Tytuł = tytuł;
        }

        public void Zapisz(ContentResolver contentResolver)
        {
            KontaktHelper.DodajKontakt(contentResolver, this);
        }

        public override string ToString()
        {
            return Tytuł + " " + NazwaWyświetlana + ", tel.: " + TelefonKomórkowy + ", e-mail: " + EmailWPracy;
        }
    }

    //pomocnik
    public static class KontaktHelper
    {
        public static List<string> ListaNazwWszystkichKontaktów(ContentResolver contentResolver)
        {
            List<string> lista = null;
            ICursor cursor = contentResolver.Query(ContactsContract.Contacts.ContentUri, null, null, null, null);
            if(cursor.Count > 0)
            {
                lista = new List<string>();
                while (cursor.MoveToNext())
                {
                    string nazwa = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.DisplayName));
                    string id = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.Id));
                    lista.Add("[" + id + "] " + nazwa);
                }
            }
            cursor.Close();
            return lista;
        }

        public static void UsuńWszystkieKontakty(ContentResolver contentResolver)
        {
            ICursor cursor = contentResolver.Query(ContactsContract.Contacts.ContentUri, null, null, null, null);
            if (cursor.Count == 0) return;
            while(cursor.MoveToNext())
            {
                string klucz = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.LookupKey));
                Uri uri = Uri.WithAppendedPath(ContactsContract.Contacts.ContentLookupUri, klucz);
                contentResolver.Delete(uri, null, null);
            }
            cursor.Close();
        }

        public static void DodajKontakt(ContentResolver contentResolver, Kontakt kontakt)
        {
            List<ContentProviderOperation> dodawanyKontakt = new List<ContentProviderOperation>();

            dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.RawContacts.ContentUri)
                .WithValue(ContactsContract.RawContacts.InterfaceConsts.AccountType, null)
                .WithValue(ContactsContract.RawContacts.InterfaceConsts.AccountName, null)
                .Build());

            if(kontakt.NazwaWyświetlana != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                    .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                    .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.StructuredName.ContentItemType)
                    .WithValue(ContactsContract.CommonDataKinds.StructuredName.DisplayName, kontakt.NazwaWyświetlana)
                    .Build());
            }

            if (kontakt.TelefonKomórkowy != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                    .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                    .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Phone.ContentItemType)
                    .WithValue(ContactsContract.CommonDataKinds.Phone.Number, kontakt.TelefonKomórkowy)
                    .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom)
                    .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Label, "Mobile")
                    .Build());
            }

            if (kontakt.TelefonDomowy != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                    .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                    .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Phone.ContentItemType)
                    .WithValue(ContactsContract.CommonDataKinds.Phone.Number, kontakt.TelefonDomowy)
                    .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom)
                    .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Label, "Home")
                    .Build());
            }

            if (kontakt.TelefonWPracy != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                    .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                    .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Phone.ContentItemType)
                    .WithValue(ContactsContract.CommonDataKinds.Phone.Number, kontakt.TelefonWPracy)
                    .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom)
                    .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Label, "Work")
                    .Build());
            }

            if (kontakt.EmailWPracy != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                    .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                    .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Email.ContentItemType)
                    .WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Data, kontakt.EmailWPracy)
                    //.WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Email.GetTypeLabelResource(EmailDataKind.Work))
                    .WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Email.InterfaceConsts.TypeCustom)
                    .WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Label, "Work")
                    .Build());
            }

            contentResolver.ApplyBatch(ContactsContract.Authority, dodawanyKontakt);
        }

        private static Kontakt odczytajKontakt(ContentResolver contentResolver, ICursor cursor)
        {
            string id = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.Id));
            string nazwaWyświetlana = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.DisplayName));
            string telefonKomórkowy = "", telefonDomowy = "", telefonWPracy = "", emailWPracy = "", firma = "", tytuł = "";

            if (int.Parse(cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.HasPhoneNumber))) > 0)
            {
                ICursor numeryTelefonów = contentResolver.Query(
                    ContactsContract.CommonDataKinds.Phone.ContentUri,
                    null,
                    ContactsContract.CommonDataKinds.Phone.InterfaceConsts.ContactId + "=" + id,
                    null,
                    null);
                while (numeryTelefonów.MoveToNext())
                {
                    string numer = numeryTelefonów.GetString(numeryTelefonów.GetColumnIndex(ContactsContract.CommonDataKinds.Phone.Number));
                    string typNumeru = numeryTelefonów.GetString(numeryTelefonów.GetColumnIndex(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Label));
                    switch (typNumeru)
                    {
                        case "Mobile": telefonKomórkowy = numer; break;
                        case "Home": telefonDomowy = numer; break;
                        case "Work": telefonWPracy = numer; break;
                    }
                }
                numeryTelefonów.Close();
            }

            ICursor adresyEmail = contentResolver.Query(
                ContactsContract.CommonDataKinds.Email.ContentUri,
                null,
                ContactsContract.CommonDataKinds.Email.InterfaceConsts.ContactId + "=" + id,
                null,
                null);
            while (adresyEmail.MoveToNext())
            {
                string adres = adresyEmail.GetString(adresyEmail.GetColumnIndex(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Data));
                string typAdresu = adresyEmail.GetString(adresyEmail.GetColumnIndex(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Label));
                switch (typAdresu)
                {
                    case "Mobile": break;
                    case "Home": break;
                    case "Work": emailWPracy = adres; break;
                }
            }
            adresyEmail.Close();

            string where = ContactsContract.Data.InterfaceConsts.ContactId + " = ? AND " + ContactsContract.Data.InterfaceConsts.Mimetype + " = ?";
            string[] whereParams = new string[]
            {
                id,
                ContactsContract.CommonDataKinds.Organization.ContentItemType
            };
            ICursor organizacje = contentResolver.Query(ContactsContract.Data.ContentUri, null, where, whereParams, null);
            if(organizacje.MoveToNext())
            {
                firma = organizacje.GetString(organizacje.GetColumnIndex(ContactsContract.CommonDataKinds.Organization.InterfaceConsts.Data));
                tytuł = organizacje.GetString(organizacje.GetColumnIndex(ContactsContract.CommonDataKinds.Organization.Title));
            }
            organizacje.Close();

            return new Kontakt(nazwaWyświetlana, telefonKomórkowy, telefonDomowy, telefonWPracy, emailWPracy, firma, tytuł);
        }

        public static Kontakt[] ListaWszystkichKontaktów(ContentResolver contentResolver)
        {
            List<Kontakt> lista = null;
            ICursor cursor = contentResolver.Query(ContactsContract.Contacts.ContentUri, null, null, null, null);
            if (cursor.Count > 0)
            {
                lista = new List<Kontakt>();
                while (cursor.MoveToNext())
                {
                    Kontakt kontakt = odczytajKontakt(contentResolver, cursor);
                    lista.Add(kontakt);
                }
                return lista.ToArray();
            }
            else return null;
        }

        public static string[] ListaOpisówWszystkichKontaktów(ContentResolver contentResolver)
        {
            Kontakt[] kontakty = ListaWszystkichKontaktów(contentResolver);
            string[] opisy = new string[kontakty.Length];
            for(int i = 0; i < opisy.Length; ++i)
            {
                opisy[i] = kontakty[i].ToString();
            }
            return opisy;
        }
    }
}