﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;

namespace BazaDanych
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private void pokażOsoby(Osoba[] osoby)
        {
            TextView tv = FindViewById<TextView>(Resource.Id.textView);
            string s = "Rekordy:";
            foreach (Osoba osoba in osoby) s += "\n" + osoba.ToString();
            tv.Text = s;
        }

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            /*
            //usuwam bazę danych - to ma sens tylko w trakcie nauki
            bool wynik = this.DeleteDatabase(Osoba.NazwaBazyDanych);
            Toast.MakeText(ApplicationContext, "Usunięcie bazy danych: " + wynik.ToString(), ToastLength.Short).Show();

            //tworzenie bazy i zapełnianie danymi
            BazaDanychOsob bdo = new BazaDanychOsob(this);
            bdo.DodajRekord(new Osoba(0, "Jan", "Kowalski", 45, 12345678));
            bdo.DodajRekord(new Osoba(1, "John", "Smith", 34, 21783681));
            bdo.DodajRekord(new Osoba(2, "Hans", "Miller", 57, 28372834));

            //manipulacje bazą danych
            //bdo.UsuńRekord(1);
            //bdo.ZmieńRekord(1, new Osoba(4, "Jean", "Dupont", 50, 21374873));
                
            //czytanie bazy danych
            Osoba[] osoby = bdo.PobierzWszystkieRekordy("Wiek");
            //pokażOsoby(osoby);

            //XML
            string nazwaPlikuXml = "osoby.xml";
            //PlikXml.ZapiszDoPlikuXml(osoby, this, nazwaPlikuXml);
            osoby.ZapiszDoPlikuXml(this, nazwaPlikuXml);

            Osoba[] osoby1 = PlikXml.CzytajOsobyZPlikuXml(this, nazwaPlikuXml);
            pokażOsoby(osoby1);
            */

            Osoba[] osoby = null;
            Java.Lang.Thread t = new Java.Lang.Thread(
                () =>
                {
                    Java.Net.URL url = new Java.Net.URL("http://www.fizyka.umk.pl/~jacek/dydaktyka/mobilne/2019L_KLUCZ/osoby.xml");
                    osoby = PlikXml.CzytajOsobyZPlikuXml(url);
                });
            t.Start();
            t.Join();
            pokażOsoby(osoby);
        }
    }
}