﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.Database;
using Android.Database.Sqlite;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;

namespace BazaDanych
{
    class BazaDanychOsob : SQLiteOpenHelper
    {
        public BazaDanychOsob(Context context) 
            : base(context, "osoby.db", null, 1)
        {
        }

        public override void OnCreate(SQLiteDatabase db)
        {
            //tworzenie bazy danych
            string createCommand = "create table " + Osoba.NazwaTabeli + "(";
            for(int numerKolumny = 0; numerKolumny < Osoba.NazwyKolumnTabeli.Length; ++numerKolumny)
            {
                createCommand += Osoba.NazwyKolumnTabeli[numerKolumny] + " " + Osoba.WłasnościKolumnTabeli[numerKolumny] + ",";
            }
            createCommand = createCommand.TrimEnd(',') + ")";
            db.ExecSQL(createCommand);
        }

        public override void OnUpgrade(SQLiteDatabase db, int oldVersion, int newVersion)
        {
            //aktualizacja bazy danych przy zmianie wersji
        }

        private ContentValues wartościZOsoby(Osoba osoba)
        {
            ContentValues wartości = new ContentValues();
            wartości.Put(Osoba.NazwyKolumnTabeli[0], osoba.Id);
            wartości.Put(Osoba.NazwyKolumnTabeli[1], osoba.Imię);
            wartości.Put(Osoba.NazwyKolumnTabeli[2], osoba.Nazwisko);
            wartości.Put(Osoba.NazwyKolumnTabeli[3], osoba.Wiek);
            wartości.Put(Osoba.NazwyKolumnTabeli[4], osoba.NumerTelefonu);
            return wartości;
        }

        private Osoba osobaZWartości(ICursor karetka)
        {
            Osoba osoba = new Osoba(
                karetka.GetInt(0),
                karetka.GetString(1),
                karetka.GetString(2),
                karetka.GetInt(3),
                karetka.GetInt(4));
            return osoba;
        }

        public void DodajRekord(Osoba osoba)
        {
            SQLiteDatabase db = this.WritableDatabase;
            ContentValues wartości = wartościZOsoby(osoba);
            db.InsertOrThrow(Osoba.NazwaTabeli, null, wartości);
        }

        public Osoba[] PobierzWszystkieRekordy(string orderBy)
        {
            SQLiteDatabase db = this.ReadableDatabase;
            ICursor karetka = db.Query(Osoba.NazwaTabeli, Osoba.NazwyKolumnTabeli, null, null, null, null, orderBy);
            List<Osoba> lista = new List<Osoba>();
            while(karetka.MoveToNext())
            {
                lista.Add(osobaZWartości(karetka));
            }
            karetka.Close();
            return lista.ToArray();
        }

        public Osoba[] PobierzWszystkieRekordy()
        {
            return PobierzWszystkieRekordy(null);
        }

        public bool UsuńRekord(int id)
        {
            SQLiteDatabase db = WritableDatabase;
            string[] whereArgs = { id.ToString() };
            return db.Delete(Osoba.NazwaTabeli, "Id=?", whereArgs) > 0;
        }

        public bool ZmieńRekord(int id, Osoba osoba)
        {
            SQLiteDatabase db = WritableDatabase;
            ContentValues wartości = wartościZOsoby(osoba);
            string[] whereArgs = { id.ToString() };
            return db.Update(Osoba.NazwaTabeli, wartości, "Id=?", whereArgs) > 0;
        }
    }
}