﻿using System.Collections.Generic;

using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using Android.Content.PM;

using JacekMatulewski.Android;
using Android.Content;

namespace Kontakty
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private Kontakt[] lista = null;
        private bool obsługaTelefonuMożliwa = false;

        private TextView naglowek;
        private ListView listaKontaktow;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            naglowek = FindViewById<TextView>(Resource.Id.naglowek);
            listaKontaktow = FindViewById<ListView>(Resource.Id.listaKontaktow);

            listaKontaktow.ItemLongClick += listaKontaktow_ItemLongClick;

            if (Build.VERSION.SdkInt >= Android.OS.BuildVersionCodes.M &&
                (this.CheckSelfPermission(Android.Manifest.Permission.CallPhone) != Android.Content.PM.Permission.Granted ||
                 this.CheckSelfPermission(Android.Manifest.Permission.SendSms) != Android.Content.PM.Permission.Granted))
            {
                this.RequestPermissions(new string[] { Android.Manifest.Permission.CallPhone, Android.Manifest.Permission.SendSms }, PERMISSION_REQUEST_PHONE_THINGS);
                Toast.MakeText(this, "Wysłana prośba o uprawnienia do obsługi telefonu", ToastLength.Short).Show();
            }
            else obsługaTelefonuMożliwa = true;

            if (Build.VERSION.SdkInt >= Android.OS.BuildVersionCodes.M &&
                this.CheckSelfPermission(Android.Manifest.Permission.WriteContacts) != Android.Content.PM.Permission.Granted)
            {
                this.RequestPermissions(new string[] { Android.Manifest.Permission.WriteContacts }, PERMISSION_REQUEST_WRITE_CONTACTS);
                Toast.MakeText(this, "Wysłana prośba o uprawnienia do zmiany kontaktów", ToastLength.Short).Show();
            }
            else
            {
                //TESTY - POCZĄTEK
                try
                {
                    KontaktHelper.UsuńWszystkieKontakty(this.ContentResolver);
                    Kontakt kontakt1 = new Kontakt("Jan Kowalski", "+48 123456789", "+48 (56) 11238489", "+48 (52) 23847897", "jacek@phys.uni.torun.pl", "UMK w Toruniu", "Dr");
                    Kontakt kontakt2 = new Kontakt("Drugi Kontakt", "+48 231423", "+48 (56) 32435", "+48 (52) 1234565", "drugi@phys.uni.torun.pl", null, null);
                    KontaktHelper.DodajKontakt(this.ContentResolver, kontakt1);
                    kontakt2.Zapisz(this.ContentResolver);
                }
                catch(Java.Lang.Exception exc)
                {
                    Toast.MakeText(this, exc.Message, ToastLength.Long).Show();
                }
                //TESTY - KONIEC
            }

            //lista = KontaktHelper.ListaNazwWszystkichKontaktów(this.ContentResolver);
            lista = KontaktHelper.ListaWszystkichKontaktów(this.ContentResolver);

            if (Build.VERSION.SdkInt >= Android.OS.BuildVersionCodes.M &&
                this.CheckSelfPermission(Android.Manifest.Permission.ReadContacts) != Android.Content.PM.Permission.Granted)
            {
                this.RequestPermissions(new string[] { Android.Manifest.Permission.ReadContacts }, PERMISSION_REQUEST_READ_CONTACTS);
            }
            else showContacts();
        }

        private void listaKontaktow_ItemLongClick(object sender, AdapterView.ItemLongClickEventArgs e)
        {
            if(!obsługaTelefonuMożliwa)
            {
                Toast.MakeText(this, "Obsługa funkcji telefonu nie jest możliwa", ToastLength.Long).Show();
                return;
            }

            Kontakt kontakt = lista[e.Position];

            Android.App.AlertDialog.Builder adb = new Android.App.AlertDialog.Builder(e.Parent.Context);
            adb.SetTitle(kontakt.NazwaWyświetlana);
            string[] etykiety = { "Zadzwoń (tel. kom.)", "Wyślij SMS", "Napisz e-mail", "Anuluj" };
            adb.SetItems(
                etykiety,
                (object _sender, DialogClickEventArgs _e) =>
                {
                    switch(_e.Which)
                    {
                        case 0:
                            Intent i = new Intent(Intent.ActionCall);
                            //Intent i = new Intent(Intent.ActionDial);
                            i.SetData(Android.Net.Uri.Parse("tel:" + kontakt.TelefonKomórkowy));
                            StartActivity(i);
                            break;
                        case 1:
                            //SMS
                            break;
                        case 2:
                            //e-mail
                            break;
                        case 3:
                            break;
                    }
                });
            Android.App.AlertDialog ad = adb.Create();
            ad.Show();
        }

        private const int PERMISSION_REQUEST_READ_CONTACTS = 100;
        private const int PERMISSION_REQUEST_WRITE_CONTACTS = 101;
        private const int PERMISSION_REQUEST_PHONE_THINGS = 102;

        private void showContacts()
        {
            List<string> listaOpisówKontaktów = new List<string>();
            foreach (Kontakt kontakt in lista) listaOpisówKontaktów.Add(kontakt.ToString());

            if (lista != null)
            {
                naglowek.Text = "Kontakty (" + lista.Length.ToString() + ")";
                ArrayAdapter<string> adapter = new ArrayAdapter<string>(this, Android.Resource.Layout.SimpleListItem1, listaOpisówKontaktów);
                listaKontaktow.Adapter = adapter;               
            }
            else
            {
                naglowek.Text = "Brak kontaktów";
            }
        }

        public override void OnRequestPermissionsResult(int requestCode, string[] permissions, [GeneratedEnum] Permission[] grantResults)
        {
            base.OnRequestPermissionsResult(requestCode, permissions, grantResults);

            if(requestCode == PERMISSION_REQUEST_READ_CONTACTS)
            {
                if (grantResults[0] == Permission.Granted) showContacts();
                else Toast.MakeText(this, "Nie została udzielona zgoda na odczyt kontaktów", ToastLength.Long).Show();
            }
            if(requestCode == PERMISSION_REQUEST_WRITE_CONTACTS)
            {
                if(grantResults[0] == Permission.Granted) Toast.MakeText(this, "Udzielona została zgoda na odczyt kontaktów. Uruchom aplikację ponownie", ToastLength.Long).Show();
                else Toast.MakeText(this, "Nie została udzielona zgoda na zmianę kontaktów", ToastLength.Long).Show();
            }
            if(requestCode == PERMISSION_REQUEST_PHONE_THINGS)
            {
                if (grantResults[0] == Permission.Granted && grantResults[1] == Permission.Granted)
                {
                    obsługaTelefonuMożliwa = true;
                    Toast.MakeText(this, "Udzielona została zgoda na obsługę telefonu", ToastLength.Long).Show();
                }
                else Toast.MakeText(this, "Nie została udzielona zgoda na obsługę telefonu", ToastLength.Long).Show();
            }
        }
    }
}