﻿using System.Collections.Generic;

using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using Android.Content.PM;

namespace Kontakty
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private TextView naglowek;
        private ListView listaKontaktow;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            naglowek = FindViewById<TextView>(Resource.Id.naglowek);
            listaKontaktow = FindViewById<ListView>(Resource.Id.listaKontaktow);

            if (Build.VERSION.SdkInt >= Android.OS.BuildVersionCodes.M &&
                this.CheckSelfPermission(Android.Manifest.Permission.ReadContacts) != Android.Content.PM.Permission.Granted)
            {
                this.RequestPermissions(new string[] { Android.Manifest.Permission.ReadContacts }, PERMISSION_REQUEST_READ_CONTACTS);
            }
            else showContacts();
        }

        private const int PERMISSION_REQUEST_READ_CONTACTS = 100;

        private void showContacts()
        {
            List<string> lista = Kontakt.ListaNazwWszystkichKontaktów(this.ContentResolver);

            if(lista != null)
            {
                naglowek.Text = "Kontakty (" + lista.Count.ToString() + ")";
                ArrayAdapter<string> adapter = new ArrayAdapter<string>(this, Android.Resource.Layout.SimpleListItem1, lista);
                listaKontaktow.Adapter = adapter;               
            }
            else
            {
                naglowek.Text = "Brak kontaktów";
            }
        }

        public override void OnRequestPermissionsResult(int requestCode, string[] permissions, [GeneratedEnum] Permission[] grantResults)
        {
            base.OnRequestPermissionsResult(requestCode, permissions, grantResults);

            if(requestCode == PERMISSION_REQUEST_READ_CONTACTS)
            {
                if (grantResults[0] == Permission.Granted) showContacts();
                else Toast.MakeText(this, "Nie została udzielona zgoda na odczyt kontaktów", ToastLength.Long).Show();
            }
        }
    }
}