﻿using Android.App;
using Android.Widget;
using Android.OS;
using Android.Graphics;
using Android.Graphics.Drawables;
using Android.Graphics.Drawables.Shapes;
using Android.Content;
using Android.Preferences;

namespace Kolory
{
    [Activity(Label = "Kolory", MainLauncher = true)]
    public class MainActivity : Activity
    {
        private TextView etykieta_panel;
        private SeekBar seekBarR, seekBarG, seekBarB;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);

            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.Main);

            etykieta_panel = FindViewById<TextView>(Resource.Id.panel);
            seekBarR = FindViewById<SeekBar>(Resource.Id.seekBarR);
            seekBarG = FindViewById<SeekBar>(Resource.Id.seekBarG);
            seekBarB = FindViewById<SeekBar>(Resource.Id.seekBarB);

            seekBarR.ProgressChanged += SeekBar_ProgressChanged;
            seekBarG.ProgressChanged += SeekBar_ProgressChanged;
            seekBarB.ProgressChanged += SeekBar_ProgressChanged;

            float promień = 8;
            float[] zewnętrznePromienie = new float[] { promień, promień, promień, promień, promień, promień, promień, promień };
            RoundRectShape rrs = new RoundRectShape(zewnętrznePromienie, null, null);

            ShapeDrawable sdR = new ShapeDrawable(rrs);
            sdR.Paint.SetShader(new LinearGradient(0, 0, 200, 0, Color.Black, Color.Red, Shader.TileMode.Clamp));
            seekBarR.ProgressDrawable = sdR;

            odtwórzStan();
        }

        private void SeekBar_ProgressChanged(object sender, SeekBar.ProgressChangedEventArgs e)
        {
            int r = seekBarR.Progress;
            int g = seekBarG.Progress;
            int b = seekBarB.Progress;

            float[] hsvComponents = { 0f, 0f, 0f };
            Color.RGBToHSV(r, g, b, hsvComponents);

            string rgb = 
                r.ToString("X2").ToUpper() + " " +
                g.ToString("X2").ToUpper() + " " +
                b.ToString("X2").ToUpper();
            string hsv =
                (Java.Lang.Math.Round(100 * hsvComponents[0]) / 100f).ToString() + " " +
                (Java.Lang.Math.Round(100 * hsvComponents[1]) / 100f).ToString() + " " +
                (Java.Lang.Math.Round(100 * hsvComponents[2]) / 100f).ToString();


            etykieta_panel.SetBackgroundColor(Color.Argb(255, r, g, b));
            etykieta_panel.Text = this.GetString(Resource.String.skladowe_koloru) + "\nRGB: " + rgb + "\nHSV: " + hsv;

            int jasność = (r + g + b) / 3;
            etykieta_panel.SetTextColor(
                jasność > 127 ? Color.Black : Color.White);
        }

        #region Ustawienia
        const string skladowaR = "SkladowaR";
        const string skladowaG = "SkladowaG";
        const string skladowaB = "SkladowaB";

        private void zapiszStan()
        {
            ISharedPreferencesEditor edytorUstawień = PreferenceManager.GetDefaultSharedPreferences(this).Edit();
            edytorUstawień.PutInt(skladowaR, seekBarR.Progress);
            edytorUstawień.PutInt(skladowaG, seekBarG.Progress);
            edytorUstawień.PutInt(skladowaB, seekBarB.Progress);
            edytorUstawień.Commit();
        }

        private bool odtwórzStan()
        {
            ISharedPreferences ustawienia = PreferenceManager.GetDefaultSharedPreferences(this);
            seekBarR.Progress = ustawienia.GetInt(skladowaR, 0);
            seekBarG.Progress = ustawienia.GetInt(skladowaG, 0);
            seekBarB.Progress = ustawienia.GetInt(skladowaB, 0);
            return ustawienia.Contains(skladowaR) && ustawienia.Contains(skladowaG) && ustawienia.Contains(skladowaB);
        }
        #endregion

        protected override void OnPause()
        {
            base.OnPause();
            zapiszStan();
        }
    }
}

