package pl.umk.fizyka.grafika2d;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;

public class Grafika2DView extends View
{
    Paint paint;
    int szerokość, wysokość;

    public Grafika2DView(Context context, AttributeSet attributeSet)
    {
        super(context, attributeSet);

        paint = new Paint(Paint.ANTI_ALIAS_FLAG);
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        paint.setStrokeWidth(3);

        szerokość = getWidth();
        wysokość = getHeight();
        Log.d("View.ctor", "Szerokość: " + Integer.toString(szerokość));
        Log.d("View.ctor", "Wysokość: " + Integer.toString(wysokość));

        setBackgroundColor(Color.CYAN);
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh)
    {
        super.onSizeChanged(w, h, oldw, oldh);

        szerokość = getWidth();
        wysokość = getHeight();
        Log.d("View.onSizeChanged", "Szerokość: " + Integer.toString(szerokość));
        Log.d("View.onSizeChanged", "Wysokość: " + Integer.toString(wysokość));

        prost1 = new Rect(0, wysokość / 2, szerokość, wysokość);
        prost2 = new Rect(szerokość / 10, wysokość / 3, szerokość / 2, 2 * wysokość / 3);
        prost3 = new Rect(7 * szerokość / 40, 9 * wysokość / 20, 5 * szerokość / 20, 2 * wysokość / 3);

        ścieżka = new Path();
        ścieżka.setFillType(Path.FillType.EVEN_ODD);
        ścieżka.moveTo(1 * szerokość / 10, wysokość / 3);
        ścieżka.lineTo(2 * szerokość / 10, wysokość / 6);
        ścieżka.lineTo(4 * szerokość / 10, wysokość / 6);
        ścieżka.lineTo(5 * szerokość / 10, wysokość / 3);
        ścieżka.lineTo(1 * szerokość / 10, wysokość / 3);
        ścieżka.close();

        obraz = BitmapFactory.decodeResource(getResources(), R.mipmap.ic_launcher);
        if(obraz == null) Log.e("View.onSizeChanged", "Obraz nie został poprawnie wczytany");

        szerokośćBelki = wysokość / 15;
        szerokośćSztachety = szerokość / 18;
        luka = szerokość / 40;
        belka1 = new Rect(szerokość / 2, wysokość / 3 + szerokośćBelki, 8 * szerokość / 9,wysokość / 3 + 2 * szerokośćBelki);
        belka2 = new Rect(szerokość / 2, 2 * wysokość / 3 - szerokośćBelki, 8 * szerokość / 9,2 * wysokość / 3 - 2 * szerokośćBelki);
        sztacheta = new Path();
        sztacheta.setFillType(Path.FillType.EVEN_ODD);
    }

    Rect prost1, prost2, prost3;
    Path ścieżka;
    Bitmap obraz;
    static long aktualnyCzas = -1, poprzedniCzas = -1;
    Rect belka1, belka2;
    Path sztacheta;
    int szerokośćSztachety, luka, szerokośćBelki;

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        paint.setColor(Color.YELLOW);
        int x0 = 4 * szerokość / 5;
        int y0 = wysokość / 4;
        int r1 = wysokość / 10;
        int r2 = 2 * r1;
        canvas.drawCircle(x0, y0, r1, paint);

        int ilePromieni = 8;
        double wsp = 2 * Math.PI / ilePromieni;
        for (int i = 0; i < ilePromieni; ++i) {
            canvas.drawLine(x0, y0, x0 + (float) (r2 * Math.cos(wsp * i)), y0 + (float) (r2 * Math.sin(wsp * i)), paint);
        }

        //ziemia
        paint.setColor(Color.argb(255, 191, 255, 0));
        canvas.drawRect(prost1, paint);

        //sciany
        paint.setColor(Color.WHITE);
        canvas.drawRect(prost2, paint);

        //drzwi
        paint.setColor(Color.argb(255, 0, 125, 0));
        canvas.drawRect(prost3, paint);

        //okno
        int _x0 = 13 * szerokość / 40;
        int _y0 = 2 * wysokość / 5;
        paint.setColor(Color.CYAN);
        for (int ix = 0; ix < 2; ++ix)
            for (int iy = 0; iy < 2; ++iy)
            {
                int x1 = _x0 + ix * szerokość / 15;
                int y1 = _y0 + iy * wysokość / 15;
                int x2 = x1 + szerokość / 20;
                int y2 = y1 + wysokość / 20;
                canvas.drawRect(new Rect(x1, y1, x2, y2), paint);
            }

        //dach
        paint.setColor(Color.RED);
        canvas.drawPath(ścieżka, paint);

        //obraz
        int bmpX0 = szerokość / 2;
        int bmpY0 = 4 * wysokość / 10;
        float bmpWsp = (float)obraz.getHeight() / obraz.getWidth();
        int dx = szerokość / 5;
        int dy = (int)(bmpY0*bmpWsp);
        //canvas.drawBitmap(obraz, null, new Rect(bmpX0, bmpY0, bmpX0 + dx, bmpY0 + dy), paint);

        //animacja
        if(aktualnyCzas < 0)
        {
            aktualnyCzas = System.currentTimeMillis();
            poprzedniCzas = aktualnyCzas;
        }
        else
        {
            poprzedniCzas = aktualnyCzas;
            aktualnyCzas = System.currentTimeMillis();
        }

        final double f = 0.001;
        int xs = (int)(szerokość / 4 * Math.sin(f * aktualnyCzas));
        canvas.drawBitmap(obraz, null, new Rect(bmpX0 + xs, bmpY0, bmpX0 + xs + dx, bmpY0 + dy), paint);

        //płot
        int kolorPłotu = Color.argb(255,128,0,0);
        paint.setColor(kolorPłotu);
        canvas.drawRect(belka1,paint);
        canvas.drawRect(belka2,paint);
        paint.setColor(kolorPłotu);
        int początekRys; // miejsce, gdzie zaczynamy rysowanie ścieżki sztachety
        for (int i = 0; i < 5; i++) {
            początekRys = i * (szerokośćSztachety + luka);
            sztacheta.moveTo(szerokość / 2 + szerokośćSztachety / 2 + początekRys, wysokość / 3 - szerokośćBelki);
            sztacheta.lineTo(szerokość / 2 + szerokośćSztachety + początekRys, wysokość / 3);
            sztacheta.lineTo( szerokość / 2 + szerokośćSztachety + początekRys, 2 * wysokość / 3);
            sztacheta.lineTo(szerokość / 2 + początekRys, 2 * wysokość / 3);
            sztacheta.lineTo(szerokość / 2 + początekRys, wysokość / 3);
            sztacheta.lineTo(szerokość / 2 + szerokośćSztachety / 2 + początekRys, wysokość / 3 - szerokośćBelki);
            sztacheta.close();
            canvas.drawPath(sztacheta, paint);
        }

        invalidate();
    }
}
