package pl.umk.fizyka.grafika2d;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;

public class Grafika2DView extends View
{
    Paint paint;
    int szerokość, wysokość;

    public Grafika2DView(Context context, AttributeSet attributeSet)
    {
        super(context, attributeSet);

        paint = new Paint(Paint.ANTI_ALIAS_FLAG);
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        paint.setStrokeWidth(3);

        szerokość = getWidth();
        wysokość = getHeight();
        Log.d("View.ctor", "Szerokość: " + Integer.toString(szerokość));
        Log.d("View.ctor", "Wysokość: " + Integer.toString(wysokość));

        setBackgroundColor(Color.CYAN);
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh)
    {
        super.onSizeChanged(w, h, oldw, oldh);

        szerokość = getWidth();
        wysokość = getHeight();
        Log.d("View.onSizeChanged", "Szerokość: " + Integer.toString(szerokość));
        Log.d("View.onSizeChanged", "Wysokość: " + Integer.toString(wysokość));
    }

    @Override
    protected void onDraw(Canvas canvas)
    {
        super.onDraw(canvas);

        paint.setColor(Color.YELLOW);
        int x0 = 4 * szerokość / 5;
        int y0 = wysokość / 4;
        int r1 = wysokość / 10;
        int r2 = 2 * r1;
        canvas.drawCircle(x0, y0, r1, paint);

        int ilePromieni = 8;
        double wsp = 2*Math.PI/ilePromieni;
        for(int i = 0; i < ilePromieni; ++i)
        {
            canvas.drawLine(x0, y0, x0+(float)(r2*Math.cos(wsp*i)), y0+(float)(r2*Math.sin(wsp*i)), paint);
        }
    }
}
