package pl.umk.fizyka.uslugi;

import android.app.Service;
import android.content.Intent;
import android.media.AudioManager;
import android.media.ToneGenerator;
import android.os.IBinder;
import android.widget.Toast;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;

public class Usluga extends Service
{
    private Timer timer;

    @Override
    public void onCreate()
    {
        super.onCreate();
        timer = new Timer();
        timer.scheduleAtFixedRate(
                new TimerTask() {
                    @Override
                    public void run()
                    {
                        String czas = DateFormat.getDateInstance().format(Calendar.getInstance().getTime());
                        //Toast.makeText(getApplicationContext(), "Usługa: " + czas, Toast.LENGTH_SHORT).show();
                        ToneGenerator tg = new ToneGenerator(
                                AudioManager.STREAM_ALARM,
                                100);
                        tg.startTone(ToneGenerator.TONE_CDMA_ALERT_CALL_GUARD, 1000);
                    }
                },
                1000, 5000);
        uruchomiona = true;
        Toast.makeText(
                getApplicationContext(),
                "Usługa została utworzona",
                Toast.LENGTH_SHORT).show();
    }

    @Override
    public void onDestroy()
    {
        timer.cancel();
        super.onDestroy();
        uruchomiona = false;
        Toast.makeText(
                getApplicationContext(),
                "Usługa została zniszczona",
                Toast.LENGTH_SHORT).show();
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId)
    {
        Toast.makeText(getApplicationContext(), "Usługa została uruchomiona", Toast.LENGTH_SHORT).show();
        return super.onStartCommand(intent, flags, startId);
    }

    //@androidx.annotation.Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    private static boolean uruchomiona = false;
    public static boolean czyUruchomiona()
    {
        return uruchomiona;
    }
}
