package pl.umk.fizyka.uslugi;

import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity {

    private Button uruchom, zakoncz;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        uruchom = (Button)findViewById(R.id.uruchom);
        zakoncz = (Button)findViewById(R.id.zakoncz);

        uruchom.setOnClickListener(
                new View.OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        if(!Usluga.czyUruchomiona())
                        {
                            Toast.makeText(
                                    getApplicationContext(),
                                    "Uruchamiam usługę",
                                    Toast.LENGTH_SHORT).show();
                            startService(new Intent(MainActivity.this, Usluga.class));
                        }
                        else
                        {
                            Toast.makeText(
                                    getApplicationContext(),
                                    "Usługa jest już uruchomiona",
                                    Toast.LENGTH_SHORT).show();
                        }
                    }
                }
        );
        zakoncz.setOnClickListener(
                new View.OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        if(Usluga.czyUruchomiona())
                        {
                            Toast.makeText(
                                    getApplicationContext(),
                                    "Kończę usługę",
                                    Toast.LENGTH_SHORT).show();
                            stopService(new Intent(MainActivity.this, Usluga.class));
                        }
                        else
                        {
                            Toast.makeText(
                                    getApplicationContext(),
                                    "Usługa wcale nie działa",
                                    Toast.LENGTH_SHORT).show();
                        }
                    }
                }
        );
    }
}
