﻿using Android.App;
using Android.Widget;
using Android.OS;

namespace BazaDanychSQLite
{
    [Activity(Label = "BazaDanychSQLite", MainLauncher = true)]
    public class MainActivity : Activity
    {
        TextView textView = null;

        private void pokażOsoby(Osoba[] osoby)
        {
            if(textView == null) textView = FindViewById<TextView>(Resource.Id.textView);
            string s = "Osoby:";
            foreach (Osoba osoba in osoby) s += "\n" + osoba.ToString();
            textView.Text = s;
        }

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);

            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.Main);

            /*
            //usuwanie bazę danych
            bool wynik = this.DeleteDatabase(Osoba.NazwaBazyDanych);

            //tworzenie tabeli
            BazaDanychOsoby dbm = new BazaDanychOsoby(this);    
            dbm.DodajRekord(new Osoba(0, "Kamil", "Mularski", 25, "98765432"));
            dbm.DodajRekord(new Osoba(1, "Katarzyna", "Leonarcik", 23, "0-800-IAM-PROGRAMMER"));
            dbm.DodajRekord(new Osoba(2, "Jacek", "Matulewski", 45, "1234567890"));
            */

            //odczytywanie tabeli
            BazaDanychOsoby dbm = new BazaDanychOsoby(this);
            Osoba[] osoby = dbm.PobierzWszystkieRekordy(Osoba.NazwyKolumnTabeli[1] + " desc");
            pokażOsoby(osoby);

            try
            {
                PlikXml.ZapiszOsobyDoPlikuXml(this, osoby, "osoby.xml");
            }
            catch(System.IO.IOException exc)
            {

            }
            catch(Java.Lang.Exception exc)
            {

            }
            catch(System.Exception exc)
            {

            }
        }
    }
}

