﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;
using Android.Database.Sqlite;
using Android.Database;

namespace BazaDanychSQLite
{
    class BazaDanychOsoby : SQLiteOpenHelper
    {
        public BazaDanychOsoby(Context context)
            :base(context, Osoba.NazwaBazyDanych, null, 1)
        { }

        public override void OnCreate(SQLiteDatabase db)
        {
            string createCommand = "create table " + Osoba.NazwaTabeli + "(";
            for(int i = 0; i < Osoba.NazwyKolumnTabeli.Length; ++i)
            {
                createCommand += Osoba.NazwyKolumnTabeli[i] + " " + Osoba.WłasnościKolumnTabeli + ",";
            }
            createCommand.TrimEnd(',');
            createCommand += ")";
            db.ExecSQL(createCommand);
        }

        public override void OnUpgrade(SQLiteDatabase db, int oldVersion, int newVersion)
        {
           //zmiana wersji
        }

        //CRUD - zadanie domowe: implentacja Update i Delete
        //ORM - C
        private ContentValues wartościZEncji(Osoba osoba)
        {
            ContentValues wartości = new ContentValues();
            wartości.Put(Osoba.NazwyKolumnTabeli[0], osoba.Id);
            wartości.Put(Osoba.NazwyKolumnTabeli[1], osoba.Imię);
            wartości.Put(Osoba.NazwyKolumnTabeli[2], osoba.Nazwisko);
            wartości.Put(Osoba.NazwyKolumnTabeli[3], osoba.Wiek);
            wartości.Put(Osoba.NazwyKolumnTabeli[4], osoba.NumerTelefonu);
            return wartości;
        }

        public void DodajRekord(Osoba osoba)
        {
            SQLiteDatabase db = this.WritableDatabase;
            ContentValues wartości = wartościZEncji(osoba);
            db.InsertOrThrow(Osoba.NazwaTabeli, null, wartości);
        }

        private Osoba osobaZKaretki(ICursor karetka)
        {
            Osoba osoba = new Osoba(
                karetka.GetInt(0),
                karetka.GetString(1),
                karetka.GetString(2),
                karetka.GetInt(3),
                karetka.GetString(4));
            return osoba;
        }

        public Osoba[] PobierzWszystkieRekordy(string orderBy)
        {
            SQLiteDatabase db = this.ReadableDatabase;
            ICursor karetka = db.Query(Osoba.NazwaBazyDanych, Osoba.NazwyKolumnTabeli, null, null, null, null, orderBy);
            List<Osoba> lista = new List<Osoba>();            
            while(karetka.MoveToNext())
            {
                lista.Add(osobaZKaretki(karetka));
            }
            karetka.Close();
            return lista.ToArray();
        }

        public Osoba[] PobierzWszystkieRekordy()
        {
            return PobierzWszystkieRekordy(null);
        }
    }
}