﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;

using Java.Util;
using Android.Media;

namespace Uslugi
{
    [Service]
    public class Usluga : Service
    {
        public override IBinder OnBind(Intent intent)
        {
            return null;
        }

        private Timer timer;
        private static Toast toast;
        private static ToneGenerator tg = new ToneGenerator(Stream.Alarm, 100);

        class Zadanie : TimerTask
        {
            public override void Run()
            {
                //string czas = DateTime.Now.ToLongTimeString();
                //toast.SetText(czas);
                //toast.Show();
                
                tg.StartTone(Tone.CdmaAlertCallGuard, 200);
            }
        }

        public override void OnCreate()
        {
            base.OnCreate();

            toast = Toast.MakeText(ApplicationContext, "", ToastLength.Short);

            timer = new Timer();
            timer.ScheduleAtFixedRate( //do domu: użyć timer z .NET i sprawdzić, czy są te same problemy
                new Zadanie(), 1000, 2000);
            CzyUtworzona = true;
            Toast.MakeText(ApplicationContext, "Utworzono usługę", ToastLength.Short).Show();
        }

        public override void OnDestroy()
        {
            timer.Cancel();
            CzyUtworzona = false;
            Toast.MakeText(ApplicationContext, "Zatrzymano usługę", ToastLength.Short).Show();
            base.OnDestroy();
        }

        [return: GeneratedEnum]
        public override StartCommandResult OnStartCommand(Intent intent, [GeneratedEnum] StartCommandFlags flags, int startId)
        {
            Toast.MakeText(ApplicationContext, "Uruchomiono usługę", ToastLength.Short).Show();
            return base.OnStartCommand(intent, flags, startId);
        }

        public static bool CzyUtworzona { get; private set; } = false;
    }
}