﻿using Android.App;
using Android.Widget;
using Android.OS;
using Android.Content;

namespace Powiadomienia
{
    [Activity(Label = "Powiadomienia", MainLauncher = true)]
    public class MainActivity : Activity
    {
        private EditText tytuł, treść;
        private Button pokaż, ukryj;
        private const int idPowiadomienia = 0;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);

            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.Main);

            tytuł = FindViewById<EditText>(Resource.Id.tytul);
            treść = FindViewById<EditText>(Resource.Id.tresc);
            pokaż = FindViewById<Button>(Resource.Id.pokaz);
            ukryj = FindViewById<Button>(Resource.Id.ukryj);

            pokaż.Click += pokaż_Click;
            ukryj.Click += ukryj_Click;
        }

        private void pokaż_Click(object sender, System.EventArgs e)
        {
            Intent i = new Intent(ApplicationContext, typeof(MainActivity));
            PendingIntent pi = PendingIntent.GetActivity(ApplicationContext, 0, i, 0);

            NotificationManager nm = (NotificationManager)GetSystemService(NotificationService);

            //API >= 26
            //string idKanału = "kanał";
            //nm.CreateNotificationChannel(new NotificationChannel(idKanału, "Kanał UMK", NotificationImportance.Default));

            Notification.Builder nb = new Notification.Builder(ApplicationContext/*, idKanału*/);
            //nb.SetSmallIcon(Resource)
            nb.SetContentTitle(tytuł.Text);
            nb.SetContentText(treść.Text);
            nb.SetContentIntent(pi);
            //nb.AddAction(null, "Uruchom akcję 1", pi);
            //nb.AddAction(null, "Uruchom akcję 2", pi);

            Notification n = nb.Build();
            n.Flags |= NotificationFlags.AutoCancel;

            nm.Notify(idPowiadomienia, n);
        }

        private void ukryj_Click(object sender, System.EventArgs e)
        {
            throw new System.NotImplementedException();
        }
    }
}

