﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using Android.Views;
using System.Collections.Generic;
using System.Threading;
using System;
using static Android.App.ActivityManager;
using Android.Content;
using Android.Content.PM;
using Android.Hardware;
using Android.Locations;
using Android.Support.V4.Content;
using Android;
using Android.Support.V4.App;

namespace StanUrzadzenia
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity, ISensorEventListener, ILocationListener
    {
        ListView listView;

        class _Handler : Handler
        {
            private MainActivity activity;

            public _Handler(MainActivity activity)
            {
                this.activity = activity;
            }

            public override void HandleMessage(Message message)
            {
                activity.odswiezListe();
            }
        };

        _Handler handler;        

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            TextView naglowek = FindViewById<TextView>(Resource.Id.naglowek);
            naglowek.Text += "\n" + Build.Manufacturer + " " + Build.Model + " (" + Build.Product + ")";

            listView = FindViewById<ListView>(Resource.Id.listView);
            odswiezListe();

            const int coIleMilisekundOswiezacListe = 2000; //2s
            handler = new _Handler(this);
            ThreadStart ts = new ThreadStart( //wątek .NET, alternatywnie Java.Lang.Thread
                () =>
                {
                    while (true)
                    {
                        //w osobnym watku
                        handler.SendEmptyMessage(0);
                        try
                        {
                            Thread.Sleep(coIleMilisekundOswiezacListe);
                        }
                        catch //(ThreadInterruptedException exc)
                        {
                        }
                    }
                });
            Thread timer = new Thread(ts);
            timer.Start();
        }

        class BatteryReceiver : BroadcastReceiver
        {
            public override void OnReceive(Context context, Intent intent)
            {
                int bateriaPoziom = intent.GetIntExtra(BatteryManager.ExtraLevel, -1);
                if (bateriaPoziom < 10) Toast.MakeText(context, "Nisko poziom baterii", ToastLength.Short).Show();
            }
        }

        BatteryReceiver batteryReceiver;

        private void odswiezListe()
        {
            int pozycja = listView.FirstVisiblePosition;
            View v = listView.GetChildAt(0);
            int top = (v == null) ? 0 : v.Top;

            List<UrządzenieInfo> listaUrzadzeń = new List<UrządzenieInfo>();
            /*
            listaUrzadzeń.Add(odczytajWersjęSystemu(this));
            listaUrzadzeń.Add(odczytajStanPamięci(this));
            listaUrzadzeń.Add(odczytajStanGłównejKartyPamięci(this));
            listaUrzadzeń.Add(odczytajStanDodatkowejKartyPamięci(this));
            listaUrzadzeń.Add(odczytajStanProcesora(this));
            */

            //tu dodawać opisy stanu kolejnych urzadzen
            batteryReceiver = new BatteryReceiver();
            IntentFilter intentFilter = new IntentFilter(Intent.ActionBatteryChanged);
            Intent intent = this.ApplicationContext.RegisterReceiver(batteryReceiver, intentFilter);
            listaUrzadzeń.Add(odczytStanuBaterii(this, intent));

            listaUrzadzeń.Add(odczytajObecnośćDodatkowychSensorów(this));
            listaUrzadzeń.Add(odczytajObecnośćCzcujników(this));

            listaUrzadzeń.Add(odczytajAkcelerometr(this));
            listaUrzadzeń.Add(odczytajPoleMagnetyczne(this));
            listaUrzadzeń.Add(odczytajOrientację(this));

            UrzadzeniaAdapter a = new UrzadzeniaAdapter(this, Resource.Layout.wiersz, listaUrzadzeń);
            listView.Adapter = a;

            listView.SetSelectionFromTop(pozycja, top);
        }

        protected override void OnResume()
        {
            base.OnResume();
            //Toast.MakeText(this, "Rozpoczynam odczyty czujników", ToastLength.Long).Show();

            if(sensorManager == null)
            {
                sensorManager = (SensorManager)GetSystemService(SensorService);
                akcelerometr = sensorManager.GetDefaultSensor(SensorType.Accelerometer);
                magnetometr = sensorManager.GetDefaultSensor(SensorType.MagneticField);
                orientacja = sensorManager.GetDefaultSensor(SensorType.Orientation);
                sensorManager.RegisterListener(this, akcelerometr, SensorDelay.Normal);
                sensorManager.RegisterListener(this, magnetometr, SensorDelay.Normal);
                sensorManager.RegisterListener(this, orientacja, SensorDelay.Normal);
            }
        }

        protected override void OnPause()
        {
            if (batteryReceiver != null)
            {
                Toast.MakeText(this, "Zatrzymuję!", ToastLength.Long).Show();
                this.ApplicationContext.UnregisterReceiver(batteryReceiver);
            }
            base.OnPause();

            if (sensorManager != null)
            {
                sensorManager.UnregisterListener(this);
                sensorManager = null;
                //GC.Collect();
            }
        }

        #region Metody odczytujące stan urządzenia
        static private UrządzenieInfo odczytajWersjęSystemu(Activity activity)
        {
            UrządzenieInfo systemInfo = new UrządzenieInfo();
            systemInfo.nazwa = "Wersja systemu";
            systemInfo.typInformacji = TypInformacji.Inne;
            systemInfo.polozeniePaska = -1;
            systemInfo.opis = "\nBieżąca data i czas: " + DateTime.Now.ToString();
            systemInfo.opis += "\nBieżąca data: " + DateTime.Now.ToLongTimeString();
            systemInfo.opis += "\nBieżący czas: " + DateTime.Now.ToLongDateString();
            systemInfo.opis += "\nProducent: " + Build.Manufacturer;
            systemInfo.opis += "\nUrządzenia: " + Build.Device;
            systemInfo.opis += "\nS/N: " + Build.Serial;
            systemInfo.opis += "\nWersja: " + Build.VERSION.Release + " (" + Build.VERSION.Incremental + ")";
            systemInfo.opis += "\nPoziom API: " + Build.VERSION.SdkInt;
            //systemInfo.opis += "\nTyp CPU: " + Build.CpuAbi; //deprecated
            systemInfo.opis += "\nTypy CPU: ";
            foreach(string abi in Build.SupportedAbis) //API 21
            {
                systemInfo.opis += "\n\t" + abi;
            }
            systemInfo.opis += "\nWyświetlacz: " + Build.Display;
            return systemInfo;
        }

        static private UrządzenieInfo odczytajStanPamięci(Activity activity)
        {
            //Pamięć wewnętrzna
            UrządzenieInfo pi = new UrządzenieInfo();
            pi.typInformacji = TypInformacji.StanUrzadzenia;
            pi.nazwa = "Pamięć (RAM)";

            ActivityManager am = (ActivityManager)activity.GetSystemService(ActivityService);
            MemoryInfo mi = new MemoryInfo();
            am.GetMemoryInfo(mi);
            long pamięćDostępna = mi.AvailMem / 1024; //kB
                                                      //mi.totalMem
            long pamięćCałkowita = LinuxHelper.ReadRAMTotalSizeKB();
            long pamięćZajęta = pamięćCałkowita - pamięćDostępna;
            pi.opis = "Dostępna pamięć: " + pamięćDostępna + "/" + pamięćCałkowita;
            pi.polozeniePaska = (int)(pamięćZajęta * 100 / pamięćCałkowita);
            return pi;
        }

        static private Tuple<string, int> pobierzStanPamięci(Java.IO.File memoryDirectory)
        {
            StatFs systemPlików = new StatFs(memoryDirectory.Path);
            long wolneMiejsce =
                    systemPlików.AvailableBlocksLong *
                            systemPlików.BlockSizeLong
                            / 1024 / 1024; //MB
            long rozmiar =
                    systemPlików.BlockCountLong *
                            systemPlików.BlockSizeLong
                            / 1024 / 1024; //MB
            long zajęteMiejsce = rozmiar - wolneMiejsce;

            String opis = "Ścieżka: " + memoryDirectory.Path + "\n";
            opis += "Wolne miejsce: " + wolneMiejsce + " / " + rozmiar;
            int procent = (int)(zajęteMiejsce * 100 / rozmiar);

            Tuple<string, int> tuple = new Tuple<string, int>(opis, procent);
            return tuple;
        }

        static private UrządzenieInfo odczytajStanGłównejKartyPamięci(Activity activity)
        {
            Tuple<string, int> tuple = pobierzStanPamięci(Android.OS.Environment.RootDirectory);

            UrządzenieInfo kartaPamięciInfo = new UrządzenieInfo();
            kartaPamięciInfo.typInformacji = TypInformacji.StanUrzadzenia;
            kartaPamięciInfo.nazwa = "Głowna karta pamięci";
            kartaPamięciInfo.opis = tuple.Item1;
            kartaPamięciInfo.polozeniePaska = tuple.Item2;
            return kartaPamięciInfo;
        }

        static private UrządzenieInfo odczytajStanDodatkowejKartyPamięci(Activity activity)
        {
            UrządzenieInfo kartaPamięciInfo = new UrządzenieInfo();
            kartaPamięciInfo.typInformacji = TypInformacji.StanUrzadzenia;
            kartaPamięciInfo.nazwa = "Dodatkowa karta pamięci";

            if (Android.OS.Environment.ExternalStorageState.Equals(Android.OS.Environment.MediaMounted))
            {
                Tuple<string, int> tuple = pobierzStanPamięci(Android.OS.Environment.ExternalStorageDirectory);
                kartaPamięciInfo.opis = tuple.Item1;
                kartaPamięciInfo.polozeniePaska = tuple.Item2;
            }
            else
            {
                kartaPamięciInfo.opis = "Brak";
                kartaPamięciInfo.polozeniePaska = -1;
            }
            return kartaPamięciInfo;
        }

        static private UrządzenieInfo odczytajStanProcesora(Activity activity)
        {
            UrządzenieInfo procesorInfo = new UrządzenieInfo();
            procesorInfo.typInformacji = TypInformacji.StanUrzadzenia;
            procesorInfo.nazwa = "Procesor (CPU)";
            int procesorObciążenie = (int)Math.Round(100 * LinuxHelper.ReadCPUUsage());
            String opisProcesora = LinuxHelper.ReadCPUInfo();
            procesorInfo.opis = opisProcesora + "\n";
            procesorInfo.opis += "Obciążenie procesora: " + procesorObciążenie + "%";
            procesorInfo.polozeniePaska = procesorObciążenie;
            return procesorInfo;
        }
        #endregion

        static private UrządzenieInfo odczytStanuBaterii(Activity activity, Intent intent)
        {
            UrządzenieInfo bateriaInfo = new UrządzenieInfo();
            bateriaInfo.typInformacji = TypInformacji.StanUrzadzenia;
            bateriaInfo.nazwa = "Bateria";
            if(intent.GetBooleanExtra(BatteryManager.ExtraPresent, false))
            {
                string bateriaTechnologia = intent.GetStringExtra(BatteryManager.ExtraTechnology);
                BatteryStatus bateriaStan = (BatteryStatus)intent.GetIntExtra(BatteryManager.ExtraStatus, -1);
                string bateriaStanOpis = bateriaStan.ToString();
                BatteryPlugged batteryPlugged = (BatteryPlugged)intent.GetIntExtra(BatteryManager.ExtraPlugged, -1);
                string bateriaPodłączonaOpis = batteryPlugged.ToString();
                int bateriaTemperatura = intent.GetIntExtra(BatteryManager.ExtraTemperature, -1);
                int bateriaNapięcie = intent.GetIntExtra(BatteryManager.ExtraVoltage, -1);
                bateriaInfo.opis = "Technologia: " + bateriaTechnologia;
                bateriaInfo.opis += "\nStan: " + bateriaStanOpis;
                bateriaInfo.opis += "\nPodłączona: " + bateriaPodłączonaOpis;
                bateriaInfo.opis += "\nTemparatura: " + bateriaTemperatura;
                bateriaInfo.opis += "\nNapięcie: " + bateriaNapięcie;

                int bateriaPoziom = intent.GetIntExtra(BatteryManager.ExtraLevel, -1);
                int bateriaSkala = intent.GetIntExtra(BatteryManager.ExtraScale, -1);
                bateriaInfo.opis += "\nPoziom: " + bateriaPoziom + "/" + bateriaSkala;
                bateriaInfo.polozeniePaska = bateriaPoziom * 100 / bateriaSkala;
            }   
            else
            {
                bateriaInfo.polozeniePaska = -1;
                bateriaInfo.opis = "Brak baterii";
            }
            return bateriaInfo;
        }

        private static string taknie(bool b) { return b ? "tak" : "nie"; }

        static private UrządzenieInfo odczytajObecnośćDodatkowychSensorów(Activity activity)
        {
            //Dodatkowe urządzenia
            UrządzenieInfo dodatkoweUrządzeniaInfo = new UrządzenieInfo();
            dodatkoweUrządzeniaInfo.typInformacji = TypInformacji.Inne;
            dodatkoweUrządzeniaInfo.nazwa = "Dodatkowe urządzenia";
            dodatkoweUrządzeniaInfo.polozeniePaska = -1;

            PackageManager pm = activity.PackageManager;
            bool czyTelefonObecny = pm.HasSystemFeature(PackageManager.FeatureTelephony);
            dodatkoweUrządzeniaInfo.opis = "Telefon: " + taknie(czyTelefonObecny);
            if(czyTelefonObecny)
            {
                dodatkoweUrządzeniaInfo.opis += pm.HasSystemFeature(PackageManager.FeatureTelephonyGsm) ? " (GSM)" : " (inny)";
            }
            bool czyAparatFotograficznyObecny = pm.HasSystemFeature(PackageManager.FeatureCamera);
            dodatkoweUrządzeniaInfo.opis += "\nAparat: " + taknie(czyAparatFotograficznyObecny);
            if(czyAparatFotograficznyObecny)
            {
                dodatkoweUrządzeniaInfo.opis += "\n\tAutomatyczna regulacja ostrości: " + taknie(pm.HasSystemFeature(PackageManager.FeatureCameraAutofocus));
                dodatkoweUrządzeniaInfo.opis += "\n\tLampa błyskowa: " + taknie(pm.HasSystemFeature(PackageManager.FeatureCameraFlash));
            }

            dodatkoweUrządzeniaInfo.opis += "\nCzujnik światła: " + taknie(pm.HasSystemFeature(PackageManager.FeatureSensorLight));
            dodatkoweUrządzeniaInfo.opis += "\nCzujnik zbliżeniowy: " + taknie(pm.HasSystemFeature(PackageManager.FeatureSensorProximity));
            dodatkoweUrządzeniaInfo.opis += "\nEkran wielodotykowy: " + taknie(pm.HasSystemFeature(PackageManager.FeatureTouchscreenMultitouch));

            return dodatkoweUrządzeniaInfo;
        }

        static private string opisCzujnika(IList<Sensor> lista, string nazwa)
        {
            string opis = nazwa + ": ";
            if (lista.Count > 1) opis += "\n";
            if(lista.Count > 0)
            {
                for(int i = 0; i < lista.Count; ++i)
                {
                    if (lista.Count > 1) opis += "\t";
                    Sensor czujnik = lista[i];
                    opis += czujnik.Name + ", wersja " + czujnik.Version + ", dostawca " + czujnik.Vendor;                    
                }
            }
            return opis;
        }

        static private UrządzenieInfo odczytajObecnośćCzcujników(Activity activity)
        {
            UrządzenieInfo czujnikiInfo = new UrządzenieInfo();
            czujnikiInfo.typInformacji = TypInformacji.Inne;
            czujnikiInfo.polozeniePaska = -1;
            czujnikiInfo.nazwa = "Czujniki";

            SensorManager sm = (SensorManager)activity.GetSystemService(Context.SensorService);
            czujnikiInfo.opis += opisCzujnika(sm.GetSensorList(SensorType.Accelerometer), "akcelerometr");
            czujnikiInfo.opis += "\n" + opisCzujnika(sm.GetSensorList(SensorType.Gyroscope), "żyroskop");
            czujnikiInfo.opis += "\n" + opisCzujnika(sm.GetSensorList(SensorType.Light), "światło");
            czujnikiInfo.opis += "\n" + opisCzujnika(sm.GetSensorList(SensorType.MagneticField), "pole magnetyczne");
            czujnikiInfo.opis += "\n" + opisCzujnika(sm.GetSensorList(SensorType.Orientation), "orientacja");
            czujnikiInfo.opis += "\n" + opisCzujnika(sm.GetSensorList(SensorType.Pressure), "ciśnienie");
            czujnikiInfo.opis += "\n" + opisCzujnika(sm.GetSensorList(SensorType.Temperature), "temperatura");
            czujnikiInfo.opis += "\n" + opisCzujnika(sm.GetSensorList(SensorType.AmbientTemperature), "temperatura otoczenia");

            return czujnikiInfo;
        }

        #region Akcelerometr i inne sensory
        private SensorManager sensorManager = null;
        private Sensor akcelerometr = null;
        private Sensor magnetometr = null;
        private Sensor orientacja = null; //w ADK to jest przestarzałe

        private static float ax = 0, ay = 0, az = 0, a = 0; //m/s^2        
        private static float mx = 0, my = 0, mz = 0, m = 0; //mT
        private static float oz_azymut = 0, ox_pochylenie = 0, oy_nachylenie = 0; //stopnie

        public void OnAccuracyChanged(Sensor sensor, [GeneratedEnum] SensorStatus accuracy)
        {
            //ignorujemy
        }

        public void OnSensorChanged(SensorEvent e)
        {
            switch(e.Sensor.Type)
            {
                case SensorType.Accelerometer:
                    ax = e.Values[0];
                    ay = e.Values[1];
                    az = e.Values[2];
                    a = (float)Math.Sqrt(ax * ax + ay * ay + az * az);
                    break;
                case SensorType.MagneticField:
                    mx = e.Values[0];
                    my = e.Values[1];
                    mz = e.Values[2];
                    m = (float)Math.Sqrt(mx * mx + my * my + mz * mz);
                    break;
                case SensorType.Orientation:
                    oz_azymut = e.Values[0];
                    ox_pochylenie = e.Values[1];
                    oy_nachylenie = e.Values[2];
                    break;

            }
        }

        static private UrządzenieInfo odczytajAkcelerometr(Activity activity)
        {
            UrządzenieInfo ai = new UrządzenieInfo();
            ai.typInformacji = TypInformacji.Czujnik;
            ai.nazwa = "Akcelerometr";
            ai.opis = "ax=" + ax + "\nay=" + ay + "\naz=" + az + "\na=" + a + "[m/s^2]";
            ai.polozeniePaska = (a > 100) ? 100 : (int)a;
            return ai;
        }

        static private UrządzenieInfo odczytajPoleMagnetyczne(Activity activity)
        {
            UrządzenieInfo mi = new UrządzenieInfo();
            mi.typInformacji = TypInformacji.Czujnik;
            mi.nazwa = "Pole magnetyczne";
            mi.opis = "mx=" + mx + "\nmy=" + my + "\nmz=" + mz + "\nm=" + m + "[mT]";
            mi.polozeniePaska = (m > 100) ? 100 : (int)m;
            return mi;
        }

        static private UrządzenieInfo odczytajOrientację(Activity activity)
        {
            UrządzenieInfo oi = new UrządzenieInfo();
            oi.typInformacji = TypInformacji.Czujnik;
            oi.nazwa = "Orientacja";
            oi.opis = "ox=" + ox_pochylenie + "\noy=" + oy_nachylenie + "\noz=" + oz_azymut + "[radiany]";
            oi.polozeniePaska = -1;
            return oi;
        }
        #endregion

        #region Lokacja
        private static LocationManager LocationManager;
        private static Location położenie;

        private const int requestAcessFineLocation = 2;

        static private bool zdobądźUprawnieniaDoOdczytaniaLokacji(Activity activity)
        {
            Permission permissionCheck = ContextCompat.CheckSelfPermission(activity, Manifest.Permission.AccessFineLocation);
            if(permissionCheck != Permission.Granted)
            {
                ActivityCompat.RequestPermissions(activity, new string[] { Manifest.Permission.AccessFineLocation }, requestAcessFineLocation);
                return false;
            }
            else
            {
                Toast.MakeText(activity.ApplicationContext, "Aplikacja posiada uprawnienia do odczytania dokładnego położenia", ToastLength.Long).Show();
                return true;
            }
        }

        public override void OnRequestPermissionsResult(int requestCode, string[] permissions, [GeneratedEnum] Permission[] grantResults)
        {
            switch (requestCode)
            {
                case requestAcessFineLocation:
                    if(grantResults.Length > 0 && grantResults[0] == Permission.Granted)
                    {
                        Toast.MakeText(this.ApplicationContext, "Aplikacja zdobyła uprawnienia do odczytania dokładnego położenia", ToastLength.Long).Show();
                    }
                    odswiezListe();
                    break;
            }
        }

        public void OnLocationChanged(Location location)
        {
            
        }

        public void OnProviderDisabled(string provider)
        {
            throw new NotImplementedException();
        }

        public void OnProviderEnabled(string provider)
        {
            throw new NotImplementedException();
        }

        public void OnStatusChanged(string provider, [GeneratedEnum] Availability status, Bundle extras)
        {
            throw new NotImplementedException();
        }
        #endregion
    }
}