package pl.umk.android.kolory;

import android.content.SharedPreferences;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.TextView;

public class KolorActivity extends AppCompatActivity
{
    TextView etykieta;
    SeekBar seekBarR, seekBarG, seekBarB;
    Spinner spinner;

    boolean czyUstawićSpinnerNaWskazanyPrzezSuwaki = true;

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_kolor);

        etykieta = (TextView)findViewById(R.id.etykieta);
        seekBarR = (SeekBar)findViewById(R.id.seekBarR);
        seekBarG = (SeekBar)findViewById(R.id.seekBarG);
        seekBarB = (SeekBar)findViewById(R.id.seekBarB);

        seekBarR.setOnSeekBarChangeListener(seekBarChangeListener);
        seekBarG.setOnSeekBarChangeListener(seekBarChangeListener);
        seekBarB.setOnSeekBarChangeListener(seekBarChangeListener);

        float promień = 8;
        float[] zewnętrznePromienie = { promień, promień, promień, promień, promień, promień, promień, promień };
        RoundRectShape rrs = new RoundRectShape(zewnętrznePromienie, null, null);
        ShapeDrawable sdR = new ShapeDrawable(rrs);
        sdR.getPaint().setShader(new LinearGradient(0,0,200,0, Color.BLACK, Color.RED, Shader.TileMode.CLAMP));
        seekBarR.setProgressDrawable(sdR);
        ShapeDrawable sdG = new ShapeDrawable(rrs);
        sdG.getPaint().setShader(new LinearGradient(0,0,200,0, Color.BLACK, Color.GREEN, Shader.TileMode.CLAMP));
        seekBarG.setProgressDrawable(sdG);
        ShapeDrawable sdB = new ShapeDrawable(rrs);
        sdB.getPaint().setShader(new LinearGradient(0,0,200,0, Color.BLACK, Color.BLUE, Shader.TileMode.CLAMP));
        seekBarB.setProgressDrawable(sdB);

        spinner = (Spinner)findViewById(R.id.spinner);
        ArrayAdapter<?> adapter = ArrayAdapter.createFromResource(
                this, R.array.kolory, android.R.layout.simple_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spinner.setAdapter(adapter);
        spinner.setOnItemSelectedListener(itemSelectedListener);

        if(!odtwórzStan()) spinner.setSelection(9);
    }

    private SeekBar.OnSeekBarChangeListener seekBarChangeListener = new SeekBar.OnSeekBarChangeListener()
    {
        @Override
        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser)
        {
            int r = seekBarR.getProgress();
            int g = seekBarG.getProgress();
            int b = seekBarB.getProgress();

            float[] hsvComponents = { 0f, 0f, 0f };
            Color.RGBToHSV(r, g, b, hsvComponents);

            String rgb = "#" +
                    Integer.toHexString(r).toUpperCase() +
                    Integer.toHexString(g).toUpperCase() +
                    Integer.toHexString(b).toUpperCase();
            String hsv =
                    Float.toString(Math.round(100*hsvComponents[0]) / 100f) + " " +
                    Float.toString(Math.round(100*hsvComponents[1]) / 100f) + " " +
                    Float.toString(Math.round(100*hsvComponents[2]) / 100f);

            etykieta.setBackgroundColor(Color.argb(255, r, g, b));
            //etykieta.setText("Składowe koloru: \nRGB: " + rgb + "\nHSV: " + hsv);
            etykieta.setText(getString(R.string.etykieta_skladowe) + ": \nRGB: " + rgb + "\nHSV: " + hsv);

            int jasność = (r+g+b)/3;
            //if(jasność > 127) etykieta.setTextColor(Color.BLACK);
            //else etykieta.setTextColor(Color.WHITE);
            etykieta.setTextColor(jasność>127?Color.BLACK:Color.WHITE);

            if (czyUstawićSpinnerNaWskazanyPrzezSuwaki)
                spinner.setSelection(0);
        }

        @Override
        public void onStartTrackingTouch(SeekBar seekBar) {}

        @Override
        public void onStopTrackingTouch(SeekBar seekBar) {}
    };

    private AdapterView.OnItemSelectedListener itemSelectedListener = new AdapterView.OnItemSelectedListener()
    {
        @Override
        public void onItemSelected(AdapterView<?> parent, View view, int position, long id)
        {
            czyUstawićSpinnerNaWskazanyPrzezSuwaki = false;

            switch(position)
            {
                default:
                case 0:
                    break;
                case 1: //czarny
                    seekBarR.setProgress(0);
                    seekBarG.setProgress(0);
                    seekBarB.setProgress(0);
                    break;
                case 2: //biały
                    seekBarR.setProgress(255);
                    seekBarG.setProgress(255);
                    seekBarB.setProgress(255);
                    break;
                case 3:
                    seekBarR.setProgress(255);
                    seekBarG.setProgress(0);
                    seekBarB.setProgress(0);
                    break;
                case 4:
                    seekBarR.setProgress(0);
                    seekBarG.setProgress(255);
                    seekBarB.setProgress(0);
                    break;
                case 5:
                    seekBarR.setProgress(0);
                    seekBarG.setProgress(0);
                    seekBarB.setProgress(255);
                    break;
                case 6:
                    seekBarR.setProgress(0);
                    seekBarG.setProgress(255);
                    seekBarB.setProgress(255);
                    break;
                case 7:
                    seekBarR.setProgress(255);
                    seekBarG.setProgress(0);
                    seekBarB.setProgress(255);
                    break;
                case 8:
                    seekBarR.setProgress(255);
                    seekBarG.setProgress(255);
                    seekBarB.setProgress(0);
                    break;
                case 9:
                    seekBarR.setProgress(127);
                    seekBarG.setProgress(127);
                    seekBarB.setProgress(127);
                    break;
            }

            czyUstawićSpinnerNaWskazanyPrzezSuwaki = true;
        }

        @Override
        public void onNothingSelected(AdapterView<?> parent) {}
    };

    private final String skladowaR = "SkladowaR";
    private final String skladowaG = "SkladowaG";
    private final String skladowaB = "SkladowaB";

    private void zapiszStan()
    {
        SharedPreferences.Editor edytorUstawień = getPreferences(MODE_PRIVATE).edit();
        edytorUstawień.putInt(skladowaR, seekBarR.getProgress());
        edytorUstawień.putInt(skladowaG, seekBarG.getProgress());
        edytorUstawień.putInt(skladowaB, seekBarB.getProgress());
        edytorUstawień.commit();
    }

    private boolean odtwórzStan()
    {
        SharedPreferences ustawienia = getPreferences(MODE_PRIVATE);
        seekBarR.setProgress(ustawienia.getInt(skladowaR, 0));
        seekBarG.setProgress(ustawienia.getInt(skladowaG, 0));
        seekBarB.setProgress(ustawienia.getInt(skladowaB, 0));
        return ustawienia.contains(skladowaR) && ustawienia.contains(skladowaG) && ustawienia.contains(skladowaB);
    }

    @Override
    protected void onPause()
    {
        super.onPause();
        zapiszStan();
    }
}
