package pl.umk.android.kolory;

import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.widget.SeekBar;
import android.widget.TextView;

public class KolorActivity extends AppCompatActivity
{
    TextView etykieta;
    SeekBar seekBarR, seekBarG, seekBarB;

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_kolor);

        etykieta = (TextView)findViewById(R.id.etykieta);
        seekBarR = (SeekBar)findViewById(R.id.seekBarR);
        seekBarG = (SeekBar)findViewById(R.id.seekBarG);
        seekBarB = (SeekBar)findViewById(R.id.seekBarB);

        seekBarR.setOnSeekBarChangeListener(seekBarChangeListener);
        seekBarG.setOnSeekBarChangeListener(seekBarChangeListener);
        seekBarB.setOnSeekBarChangeListener(seekBarChangeListener);

        float promień = 8;
        float[] zewnętrznePromienie = { promień, promień, promień, promień, promień, promień, promień, promień };
        RoundRectShape rrs = new RoundRectShape(zewnętrznePromienie, null, null);
        ShapeDrawable sdR = new ShapeDrawable(rrs);
        sdR.getPaint().setShader(new LinearGradient(0,0,200,0, Color.BLACK, Color.RED, Shader.TileMode.CLAMP));
        seekBarR.setProgressDrawable(sdR);
        ShapeDrawable sdG = new ShapeDrawable(rrs);
        sdG.getPaint().setShader(new LinearGradient(0,0,200,0, Color.BLACK, Color.GREEN, Shader.TileMode.CLAMP));
        seekBarG.setProgressDrawable(sdG);
        ShapeDrawable sdB = new ShapeDrawable(rrs);
        sdB.getPaint().setShader(new LinearGradient(0,0,200,0, Color.BLACK, Color.BLUE, Shader.TileMode.CLAMP));
        seekBarB.setProgressDrawable(sdB);
    }

    private SeekBar.OnSeekBarChangeListener seekBarChangeListener = new SeekBar.OnSeekBarChangeListener() {
        @Override
        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser)
        {
            int r = seekBarR.getProgress();
            int g = seekBarG.getProgress();
            int b = seekBarB.getProgress();

            etykieta.setBackgroundColor(Color.argb(255, r, g, b));
            etykieta.setText(
                    "Składowe koloru: #" +
                            Integer.toHexString(r).toUpperCase() +
                            Integer.toHexString(g).toUpperCase() +
                            Integer.toHexString(b).toUpperCase()
            );

            int jasność = (r+g+b)/3;
            //if(jasność > 127) etykieta.setTextColor(Color.BLACK);
            //else etykieta.setTextColor(Color.WHITE);
            etykieta.setTextColor(jasność>127?Color.BLACK:Color.WHITE);
        }

        @Override
        public void onStartTrackingTouch(SeekBar seekBar) {}

        @Override
        public void onStopTrackingTouch(SeekBar seekBar) {}
    };
}
