package pl.umk.android.helloworld;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity
{
    private Button przycisk;
    private TextView etykieta;
    private ListView lista;

    private View.OnClickListener przyciskListener = new View.OnClickListener()
    {
        @Override
        public void onClick(View v)
        {
            etykieta.setText("Zmieniony");
            Toast.makeText(getApplicationContext(), "Hello World!", Toast.LENGTH_SHORT).show();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        przycisk = (Button) findViewById(R.id.button1);
        //przycisk.setText("Hit me baby one more time!");
        przycisk.setOnClickListener(przyciskListener);

        etykieta = (TextView) findViewById(R.id.textView1);
        lista = (ListView) findViewById(R.id.listView1);

        String[] łańcuchy = new String[] {
                    "Aleksandra", "Katarzyna", "Dawid", "Dominik"
                };

        ArrayAdapter<String> adapter = new ArrayAdapter<String>(
                this,
                android.R.layout.simple_list_item_1,
                łańcuchy);
        lista.setAdapter(adapter);

        lista.setOnItemClickListener(
                new AdapterView.OnItemClickListener()
                {
                    @Override
                    public void onItemClick(AdapterView<?> parent, View view, int position, long id)
                    {
                        Toast.makeText(
                                getApplicationContext(),
                                "Kliknięta pozycja nr " + position + ", " + ((TextView)view).getText(),
                                Toast.LENGTH_LONG).show();
                    }
                }
        );
    }
}
