﻿using System;

namespace UMK.WzorceStrukturalne
{
    public interface IUrządzenieRTV
    {
        void Włącz();
        void Wyłącz();
        void UstawKanał(int numerKanału);
    }

    public class Telewizor : IUrządzenieRTV
    {
        public void Włącz()
        {
            Console.WriteLine("Telewizor zostal wlaczony");
        }
        public void Wyłącz()
        {
            Console.WriteLine("Telewizor zostal wylaczony");
        }
        public void UstawKanał(int numerKanału)
        {
            Console.WriteLine("Kanal w telewizorze zmieniony na: " + numerKanału);
        }
    }

    public class Radio : IUrządzenieRTV
    {
        public void Włącz()
        {
            Console.WriteLine("Radio zostalo wlaczone");
        }
        public void Wyłącz()
        {
            Console.WriteLine("Radio zostalo wylaczone");
        }
        public void UstawKanał(int numerKanału)
        {
            Console.WriteLine("Kanal w radiu zmieniony na: " + numerKanału);
        }
    }
}
