﻿using System;
using System.Collections.Generic;
using System.Linq;

//!!!kod do prezentacji wzorca Pyłek

namespace WzorceStrukturalne.Pyłek
{
    //oryginal (C++): http://advancedcppwithexamples.blogspot.com/2010/10/c-example-of-flyweight-design-pattern.html

    //Flyweight
    abstract class Znak
    {
        protected char litera; //stan wewntrzny
        protected int pozycjaWTekście; //stan zewnętrzny - to powinno zajmować dużo pamięci (tu tylko wskaźnik)
        //dodatkowo mogłaby być część obliczana np. rozmiar

        public Znak(char litera)
        {
            this.litera = litera;
            this.pozycjaWTekście = -1; //tylko wstępna inicjacja

        }

        public abstract void Wyświetl(int pozycjaWTekście); //w tym przykładzie spokojnie można by tę metodę zaimplementować tu
    }

    //ConcreteFlyweight
    class ZnakA : Znak
    {
        public ZnakA()
            : base('A')
        { }

        public override void Wyświetl(int pozycjaWTekście)
        {
            this.pozycjaWTekście = pozycjaWTekście;
            Console.WriteLine(litera + " (pozycja " + this.pozycjaWTekście + ")");
        }
    }

    //ConcreteFlyweight
    class ZnakB : Znak
    {
        public ZnakB()
            : base('B')
        { }

        public override void Wyświetl(int pozycjaWTekście)
        {
            this.pozycjaWTekście = pozycjaWTekście;
            Console.WriteLine(litera + " (pozycja " + this.pozycjaWTekście + ")");
        }
    }

    //...

    //ConcreteFlyweight
    class ZnakD : Znak
    {
        public ZnakD()
            : base('D')
        { }

        public override void Wyświetl(int pozycjaWTekście)
        {
            this.pozycjaWTekście = pozycjaWTekście;
            Console.WriteLine(litera + " (pozycja " + this.pozycjaWTekście + ")");
        }
    }

    //...

    //ConcreteFlyweight
    class ZnakJ : Znak
    {
        public ZnakJ()
            : base('J')
        { }

        public override void Wyświetl(int pozycjaWTekście)
        {
            this.pozycjaWTekście = pozycjaWTekście;
            Console.WriteLine(litera + " (pozycja " + this.pozycjaWTekście + ")");
        }
    }
    //...

    //ConcreteFlyweight
    class ZnakU : Znak
    {
        public ZnakU()
            : base('U')
        { }

        public override void Wyświetl(int pozycjaWTekście)
        {
            this.pozycjaWTekście = pozycjaWTekście;
            Console.WriteLine(litera + " (pozycja " + this.pozycjaWTekście + ")");
        }
    }

    //FlyweightFactory
    class FabrykaZnaków
    {
        private Dictionary<char, Znak> znaki = new Dictionary<char,Znak>();

        public Znak PobierzZnak(char litera)
        {
            Znak znak = null;
            if (znaki.Keys.Contains(litera)) //Contains z LINQ
            {
                znak = znaki[litera];
            }
            else
            {
                switch (litera)
                {
                    case 'A':
                        znak = new ZnakA();
                        break;
                    case 'B':
                        znak = new ZnakB();
                        break;
                    //...
                    case 'D':
                        znak = new ZnakD();
                        break;
                    //...
                    case 'J':
                        znak = new ZnakJ();
                        break;
                    //...
                    case 'U':
                        znak = new ZnakU();
                        break;
                    default:
                        Console.WriteLine("Nie zaimplementowane");
                        throw new NotImplementedException("Nie zaimplementowane");
                }
                znaki.Add(litera, znak);
            }
            return znak;
        }
    }
}
