﻿using System;

namespace WzorceOperacyjne.Polecenie
{
    /*
    //taki interfejs jest zdefiniowany w System.Windows.Input (WPF)
    public interface ICommand
    {
        event EventHandler CanExecuteChanged; //to wymaga CommandManagera lub własnego rozwiązania

        bool CanExecute(object parameter);
        void Execute(object parameter);
    }

    public class RelayCommand : ICommand
    {
        readonly Action<object> execute;
        readonly Predicate<object> canExecute;

        public RelayCommand(Action<object> execute, Predicate<object> canExecute = null)
        {
            if (execute == null) throw new ArgumentNullException("execute");
            this.execute = execute;
            this.canExecute = canExecute;
        }

        public bool CanExecute(object parameter)
        {
            return canExecute == null ? true : canExecute(parameter);
        }

        public void Execute(object parameter)
        {
            execute(parameter);
        }
    }
    */

    //---------------------------------------    

    class Konto
    {
        private int numerKonta;
        private double saldo;

        public Konto(int numerKonta, double saldoPoczatkowe)
        {
            this.numerKonta = numerKonta;
            this.saldo = saldoPoczatkowe;
        }

        public void Wpłata(double kwota)
        {
            if (kwota < 0) throw new Exception("Kwota nie moze byc ujemna");
            saldo += kwota;
            Console.WriteLine("Nastapila wplata na konto {0:d} kwoty {1:c}. Saldo po operacji {2:c}.", numerKonta, kwota, saldo);
        }

        public bool Wypłata(double kwota)
        {
            if (kwota < 0) throw new Exception("Kwota nie moze byc ujemna");
            if (saldo >= kwota)
            {
                saldo -= kwota;
                Console.WriteLine("Nastapila wyplata z konta {0:d} kwoty {1:c}. Saldo po operacji {2:c}.", numerKonta, kwota, saldo);
                return true;
            }
            else return false;
        }

        public void WyświetlSaldo()
        {
            Console.WriteLine("Saldo konta {0:d}: {1:c}.", numerKonta, saldo);
        }

        public static bool Przelew(Konto kontoPłatnika, Konto kontoOdbiorcy, double kwota)
        {
            if (kontoPłatnika.numerKonta == kontoOdbiorcy.numerKonta) throw new Exception("Nie jest możliwe wykonanie przelewu na to samo konto");

            Console.WriteLine("Przygotowanie do przelewu z konta {0:d} na konto {1:d} kwoty {2:c}.", kontoPłatnika.numerKonta, kontoOdbiorcy.numerKonta, kwota);

            //niebezpieczne ze względu na dostęp z wielu wątków!!
            if (kontoPłatnika.Wypłata(kwota))
            {
                kontoOdbiorcy.Wpłata(kwota);
                Console.WriteLine("Wykonany zostal przelew z konta {0:d} na konto {1:d} kwoty {2:c}.", kontoPłatnika.numerKonta, kontoOdbiorcy.numerKonta, kwota);
                return true;
            }
            return false;
        }
    }

    //---------------------------------------    

    //!!!zdefiniować interfejs IPolecenie i klasę PoleceniePrzelewu
}
