﻿using System;

namespace WzorceOperacyjne.Mediator_0
{
    //Implementacja listy bez mediatora
    class ElementListy<T> where T : IComparable<T>
    {
        private T wartość;
        private ElementListy<T> następnyElement;

        public ElementListy(T wartość)
        {
            this.wartość = wartość;
            this.następnyElement = null;
        }

        public void DodajElement(ElementListy<T> element)
        {
            if (następnyElement != null) następnyElement.DodajElement(element);
            else następnyElement = element;
        }

        public void PrzejrzyjListę()
        {
            Console.Write(wartość + "  ");
            if (następnyElement != null) następnyElement.PrzejrzyjListę();
            else Console.WriteLine();
        }

        //nie można usunąć bieżącego, bo nie mamy wskaźnika do poprzedniego 
        //elementu, którego pole następny powinien mieć wskaźnik do bieżącego następny
        public void UsuńElement(T wartość)
        {
            if (następnyElement != null)
                //if (następnyElement.wartość == wartość)
                if (następnyElement.wartość.CompareTo(wartość) == 0)
                    następnyElement = następnyElement.następnyElement;
                else następnyElement.UsuńElement(wartość);
        }
    }
}
