﻿namespace MVC_Labirynt.Model
{
    public enum RezultatPróbyWejścia { Nieokreślony = 0, Powodzenie, NieMożnaWejść, Zamknięte };

    //------------------------------------

    public abstract class MiejsceWLabiryncie
    {
        public abstract RezultatPróbyWejścia SpróbujWejść();
        public virtual int Wejdź(int indeksBieżącejKomórki) { return -1; }
        public virtual bool Otwórz() { return false; }
    }

    //------------------------------------

    public enum Kierunek : int { Północ = 0, Południe = 1, Wschód = 2, Zachód = 3 };

    //------------------------------------

    public class Komórka : MiejsceWLabiryncie
    {
        private int indeks;
        private MiejsceWLabiryncie[] sąsiednieMiejsca = new MiejsceWLabiryncie[4];

        public void Inicjuj(int indeks)
        {
            this.indeks = indeks;
            for (int i = 0; i < 4; i++) sąsiednieMiejsca[i] = new Ściana();
        }

        public Komórka(int indeks)
        {
            Inicjuj(indeks);
        }        

        public MiejsceWLabiryncie PobierzMiejscePoStronie(Kierunek kierunek)
        {
            return sąsiednieMiejsca[(int)kierunek];
        }

        public void PowiążZMiejscem(Kierunek kierunek, MiejsceWLabiryncie miejsce)
        {
            sąsiednieMiejsca[(int)kierunek] = miejsce;
        }

        public override RezultatPróbyWejścia SpróbujWejść()
        {
            return RezultatPróbyWejścia.Powodzenie;
        }

        public override int Wejdź(int indeksBieżącejKomórki)
        {
            return indeks;
        }

        public int PobierzIndeks()
        {
            return indeks;
        }

        public bool OtwórzDrzwi(Kierunek kierunek)
        {
            return sąsiednieMiejsca[(int)kierunek].Otwórz();
        }
        public bool OtwórzDrzwi()
        {
            bool wynik = false;
            for (int i = 0; i < 4; i++)
            {
                if (OtwórzDrzwi((Kierunek)i)) wynik = true;
            }
            return wynik;
        }
    }

    //------------------------------------

    public class Ściana : MiejsceWLabiryncie
    {
        public override RezultatPróbyWejścia SpróbujWejść()
        {
            return RezultatPróbyWejścia.NieMożnaWejść;
        }
    }

    //------------------------------------

    public class Drzwi : MiejsceWLabiryncie
    {
        private int indeksKomórki1, indeksKomórki2;
        private bool czyOtwarte;

        public void Inicjuj(int indeksKomórki1, int indeksKomórki2)
        {
            this.indeksKomórki1 = indeksKomórki1;
            this.indeksKomórki2 = indeksKomórki2;
            czyOtwarte = false;
        }

        public Drzwi(int indeksKomórki1, int indeksKomórki2)
        {
            Inicjuj(indeksKomórki1, indeksKomórki2);
        }

        public override RezultatPróbyWejścia SpróbujWejść()
        {
            return czyOtwarte ? RezultatPróbyWejścia.Powodzenie : RezultatPróbyWejścia.Zamknięte;
        }

        public override int Wejdź(int indeksBieżącejKomórki)
        {
            if (czyOtwarte) return (indeksBieżącejKomórki == indeksKomórki1) ? indeksKomórki2 : indeksKomórki1;
            else return indeksBieżącejKomórki;
        }

        public override bool Otwórz()
        {
            czyOtwarte = true;
            return czyOtwarte;
        }
    }

    //------------------------------------

    public enum StanGry { Niezakończona = 0, Śmierć, Wygrana };

    //------------------------------------

    public interface IPobieranieInformacjiOLabiryncie //osobny interfejs dla widoku
    {
        Komórka PobierzBieżącąKomórkę();
        StanGry PobierzStanGry();
    }

    public class Labirynt : IPobieranieInformacjiOLabiryncie
    {
        private int liczbaKomórek;
        private Komórka[] komórki;
        private int indeksBieżącejKomórki, indeksCelu;
        private StanGry stanGry;

        public Labirynt(int liczbaKomórek, int indeksPoczątkowejKomórki, int indeksCelu)
        {
            this.liczbaKomórek = liczbaKomórek;
            this.indeksBieżącejKomórki = indeksPoczątkowejKomórki;
            this.indeksCelu = indeksCelu;
            this.stanGry = StanGry.Niezakończona;

            komórki = new Komórka[liczbaKomórek];
        }

        public void DodajKomórkę(int indeks, Komórka komórka)
        {
            komórki[indeks] = komórka;
        }

        public Komórka PobierzBieżącąKomórkę()
        {
            return komórki[indeksBieżącejKomórki];
        }

        public RezultatPróbyWejścia PrzejdźWKierunku(Kierunek kierunek)
        {
            MiejsceWLabiryncie miejsce = PobierzBieżącąKomórkę().PobierzMiejscePoStronie(kierunek);
            RezultatPróbyWejścia wynik = miejsce.SpróbujWejść();
            if (wynik == RezultatPróbyWejścia.Powodzenie) indeksBieżącejKomórki = miejsce.Wejdź(indeksBieżącejKomórki);            
            if (indeksBieżącejKomórki == indeksCelu) stanGry = StanGry.Wygrana;            
            return wynik; //do wyświetlania
        }

        public void Zakończ()
        {
            stanGry = StanGry.Śmierć;
        }

        public StanGry PobierzStanGry()
        {
            return stanGry;
        }
    }

    //------------------------------------

    public static class PomocnikGry
    {
        public static Labirynt TwórzLabirynt()
        {
            const int liczbaKomórek = 15;
            Labirynt labirynt = new Labirynt(liczbaKomórek, 0, 14);
            Komórka[] komórki = new Komórka[liczbaKomórek];
            for (int i = 0; i < liczbaKomórek; i++) komórki[i] = new Komórka(i);

            komórki[0].PowiążZMiejscem(Kierunek.Wschód, komórki[1]);
            komórki[1].PowiążZMiejscem(Kierunek.Zachód, komórki[0]);

            komórki[1].PowiążZMiejscem(Kierunek.Wschód, komórki[2]);
            komórki[2].PowiążZMiejscem(Kierunek.Zachód, komórki[1]);

            komórki[2].PowiążZMiejscem(Kierunek.Południe, komórki[3]);
            komórki[3].PowiążZMiejscem(Kierunek.Północ, komórki[2]);

            komórki[3].PowiążZMiejscem(Kierunek.Wschód, komórki[4]);
            komórki[4].PowiążZMiejscem(Kierunek.Zachód, komórki[3]);

            komórki[4].PowiążZMiejscem(Kierunek.Wschód, komórki[5]);
            komórki[5].PowiążZMiejscem(Kierunek.Zachód, komórki[4]);

            komórki[3].PowiążZMiejscem(Kierunek.Południe, komórki[6]);
            komórki[6].PowiążZMiejscem(Kierunek.Północ, komórki[3]);

            komórki[4].PowiążZMiejscem(Kierunek.Południe, komórki[7]);
            komórki[7].PowiążZMiejscem(Kierunek.Północ, komórki[4]);

            komórki[5].PowiążZMiejscem(Kierunek.Południe, komórki[8]);
            komórki[8].PowiążZMiejscem(Kierunek.Północ, komórki[5]);

            komórki[6].PowiążZMiejscem(Kierunek.Wschód, komórki[7]);
            komórki[7].PowiążZMiejscem(Kierunek.Zachód, komórki[6]);

            komórki[7].PowiążZMiejscem(Kierunek.Wschód, komórki[8]);
            komórki[8].PowiążZMiejscem(Kierunek.Zachód, komórki[7]);

            Drzwi drzwi_6_10 = new Drzwi(6, 10);
            komórki[6].PowiążZMiejscem(Kierunek.Południe, drzwi_6_10);
            komórki[10].PowiążZMiejscem(Kierunek.Północ, drzwi_6_10);

            komórki[10].PowiążZMiejscem(Kierunek.Zachód, komórki[9]);
            komórki[9].PowiążZMiejscem(Kierunek.Wschód, komórki[10]);

            komórki[9].PowiążZMiejscem(Kierunek.Południe, komórki[11]);
            komórki[11].PowiążZMiejscem(Kierunek.Północ, komórki[9]);

            komórki[11].PowiążZMiejscem(Kierunek.Wschód, komórki[12]);
            komórki[12].PowiążZMiejscem(Kierunek.Zachód, komórki[11]);

            komórki[12].PowiążZMiejscem(Kierunek.Wschód, komórki[13]);
            komórki[13].PowiążZMiejscem(Kierunek.Zachód, komórki[12]);

            komórki[13].PowiążZMiejscem(Kierunek.Wschód, komórki[14]);
            komórki[14].PowiążZMiejscem(Kierunek.Zachód, komórki[13]);

            for (int i = 0; i < liczbaKomórek; ++i)
                labirynt.DodajKomórkę(i, komórki[i]);
            return labirynt;
        }
    }
}