﻿using System;

namespace MVC_Labirynt.Kontroler
{
    using Model;
    using Widok;

    public class Kontroler
    {
        protected Labirynt model;
        protected WidokLabiryntu widok;

        protected void SpróbujPrzejść(Kierunek kierunek)
        {
            WidokLabiryntu.WyświetlInformacjęOPróbiePrzejściaWKierunku(kierunek);
            RezultatPróbyWejścia wynik = model.PrzejdźWKierunku(kierunek);
            widok.WyświetlInformacjęORezultaciePróbyPrzejścia(wynik);
        }
        protected void SpróbujOtworzyćDrzwi()
        {
            widok.WyświetlInformacjęOPróbieOtwarciaDrzwi();
            bool wynik = model.PobierzBieżącąKomórkę().OtwórzDrzwi();
            widok.WyświetlInformacjęORezultaciePróbyOtwarciaDrzwi(wynik);            
        }

        public Kontroler()
        {
            model = PomocnikGry.TwórzLabirynt();
            widok = new WidokLabiryntu(model);
        }

        public void Uruchom()
        {
            bool zakończ = false;
            do
            {
                widok.WyświetlInformacjęOBieżącejKomórce();
                ConsoleKeyInfo klawisz = Console.ReadKey(true);
                int kodKlawisza = klawisz.KeyChar;

                switch (kodKlawisza)
                {
                    case 97:
                    case 75:
                        //przesuń na zachód
                        SpróbujPrzejść(Kierunek.Zachód);
                        break;
                    case 100:
                    case 77:
                        //przesuń na wschód
                        SpróbujPrzejść(Kierunek.Wschód);
                        break;
                    case 119:
                    case 72:
                        //przesuń na północ
                        SpróbujPrzejść(Kierunek.Północ);
                        break;
                    case 115:
                    case 80:
                        //przesuń na południe
                        SpróbujPrzejść(Kierunek.Południe);
                        break;
                    case 101:
                        SpróbujOtworzyćDrzwi();
                        break;
                    case 27:
                        model.Zakończ();
                        break;
                }

                widok.WyświetlInformacjęOStanieGry();
                if (model.PobierzStanGry() != StanGry.Niezakończona) zakończ = true;
            }
            while (!zakończ);
        }
    }
}
