﻿using System;

namespace UMK.WzorceStrukturalne
{
    //component
    abstract class Napój
    {
        public abstract decimal Cena();
        public void Objętość() //funckja nie podlegająca zmianom podczas dekoracji
        {
            Console.WriteLine("\nObjetosc: 330 ml");
        }
    }

    //concrete components
    class Herbata : Napój
    {
        public override decimal Cena()
        {
            return 6.70M;
        }

        public override string ToString()
        {
            return "Herbata";
        }
    }

    class Kawa : Napój
    {
        public override decimal Cena()
        {
            return 7.90M;
        }

        public override string ToString()
        {
            return "Kawa";
        }
    }
}
