﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Input;

namespace GazeBreakoutWPF
{
    //https://try2explore.com/questions/10082475 - zmienione na WPF
    public abstract class KeyboardHelper
    {
        [Flags]
        private enum KeyStates
        {
            None = 0,
            Down = 1,
            Toggled = 2
        }

        [DllImport("user32.dll", CharSet = CharSet.Auto, ExactSpelling = true)]
        private static extern short GetKeyState(int keyCode);

        private static KeyStates GetKeyState(Key key)
        {
            KeyStates state = KeyStates.None;

            int keyCode = KeyInterop.VirtualKeyFromKey(key);
            short retVal = GetKeyState(keyCode);

            //If the high-order bit is 1, the key is down
            //otherwise, it is up.
            if ((retVal & 0x8000) == 0x8000)
                state |= KeyStates.Down;

            //If the low-order bit is 1, the key is toggled.
            if ((retVal & 1) == 1)
                state |= KeyStates.Toggled;

            return state;
        }

        public static bool IsKeyDown(Key key)
        {
            return KeyStates.Down == (GetKeyState(key) & KeyStates.Down);
        }

        public static bool IsKeyToggled(Key key)
        {
            return KeyStates.Toggled == (GetKeyState(key) & KeyStates.Toggled);
        }
    }
}