﻿using System;

namespace BreakoutModel
{
    public class GameSettings
    {
        public enum _GameControlMode { Keyboard, Mouse, Eyetracker }
        public _GameControlMode GameControlMode = _GameControlMode.Mouse;

        public enum _PaddleControlMode { Direct, ConstantVelocity, ProportionalVelocity /*HarmonicForce*/ }
        public _PaddleControlMode PaddleControlMode = _PaddleControlMode.Direct;

        public int TimerIntervalMs = 10;

        public int BrickMarginX = 30;
        public int BrickSpacingX = 20;
        public int BrickSpacingY = 20;
        public int BrickSizeHeight = 40;

        public bool BricksCrushing = true;

        public int NumberOfBricksInRow = 10;
        public int NumberOfBrickRows = 1;

        public int MaximalNumberOfBrickRows = 5;

        [NonSerialized] public int InitialBallPositionX;
        [NonSerialized] public int InitialBallPositionY;
        public int InitialBallSizeWidth = 30;
        public int InitialBallSizeHeight = 30;
        public float InitialBallVelocityX = 0.4f;
        public float InitialBallVelocityY = -0.6f;

        public float MaximalBallVelocityX = 1.0f;

        [NonSerialized] public int InitialPaddlePositionX;
        [NonSerialized] public int InitialPaddlePositionY;
        public int InitialPaddleSizeWidth = 150;
        public int InitialPaddleSizeHeight = 30;

        public int PaddleKeyboardMoveStep = 10;
        public int PaddleConstantVelocity = 2;
        public double PaddleProportionalVelocityCoefficient = 0.01;

        public bool PaddleOverridePhysics = true;

        public static GameSettings Default
        {
            get
            {
                return new GameSettings();
            }
        }
    }
}
