﻿using System;

namespace GameLab.Geometry
{
    //using GameLab.Geometry;

    public static class ComputationalGeometry
    {
        public static bool IsLineSegmentsIntersecting(Point p1, Point p2, Point p3, Point p4, out Point? intersectionPoint)
        {
            intersectionPoint = null;

            //odcinek 1: p1 -> p2
            //odcinek 2: p3 -> p4

            double Ax = p2.X - p1.X;
            double Bx = -(p4.X - p3.X);
            double Cx = p3.X - p1.X;
            double Ay = p2.Y - p1.Y;
            double By = -(p4.Y - p3.Y);
            double Cy = p3.Y - p1.Y;

            double detA = Ax * By - Bx * Ay;
            if (detA == 0)
            {
                return false; //sprzeczny lub nieoznaczony (czyli osobno trzeba przypadek równoległy)
                //użyć iloczynu skalarnego?
            }

            //wzory Cramera
            double tr = (Cx * By - Bx * Cy) / detA;
            double ts = (Ax * Cy - Cx * Ay) / detA;

            bool wynik = tr >= 0 && tr <= 1 && ts >= 0 && ts <= 1;

            if (wynik)
            {
                double px = p1.X + tr * Ax;
                double py = p1.Y + tr * Ay;
                intersectionPoint = new Point((int)px, (int)py);
            }

            return wynik;
        }

        public static double Distance(Point p1, Point p2)
        {
            double dx = p2.X - p1.X;
            double dy = p2.Y - p1.Y;
            return Math.Sqrt(dx * dx + dy * dy);
        }
    }
}
