﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Shapes;

namespace GazeBreakoutWPF
{
    using System.Runtime.InteropServices;
    using WPFShapes = System.Windows.Shapes;

    /// <summary>
    /// Logika interakcji dla klasy MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        /*
        public class GameSettings
        {
            public enum _GameControlMode { Keyboard, Mouse, Eyetracker }
            public _GameControlMode GameControlMode = _GameControlMode.Mouse;

            public enum _PaddleControlMode { Direct, ConstantVelocity, ProportionalVelocity}
            public _PaddleControlMode PaddleControlMode = _PaddleControlMode.Direct;

            public int TimerIntervalMs = 10;

            public int BrickMarginX = 30;
            public int BrickSpacingX = 20;
            public int BrickSpacingY = 20;
            public int BrickSizeHeight = 40;

            public bool BricksCrushing = true;

            public int NumberOfBricksInRow = 10;
            public int NumberOfBrickRows = 1;

            public int MaximalNumberOfBrickRows = 5;

            [NonSerialized] public int InitialBallPositionX;
            [NonSerialized] public int InitialBallPositionY;
            public int InitialBallSizeWidth = 30;
            public int InitialBallSizeHeight = 30;
            public float InitialBallVelocityX = 0.4f;
            public float InitialBallVelocityY = -0.6f;

            public float MaximalBallVelocityX = 1.0f;

            [NonSerialized] public int InitialPaddlePositionX;
            [NonSerialized] public int InitialPaddlePositionY;
            public int InitialPaddleSizeWidth = 150;
            public int InitialPaddleSizeHeight = 30;

            public int PaddleKeyboardMoveStep = 10;
            public int PaddleConstantVelocity = 2;
            public double PaddleProportionalVelocityCoefficient = 0.01;

            public bool PaddleOverridePhysics = true;

            public static GameSettings Default
            {
                get
                {
                    return new GameSettings();
                }
            }
        }
        */

        private KonfGry _c = null;
        private Gra gra;
        private System.Windows.Threading.DispatcherTimer dispatcherTimer;
        private Cursor originalCursor;

        /*
        private void readSettings(string settingsFilePath)
        {
            JacekMatulewski.Settings.SettingsManager<GameSettings> sm = JacekMatulewski.Settings.SettingsManager<GameSettings>.Load(JacekMatulewski.Settings.StoringMethod.XmlFile, settingsFilePath);
            settings = sm.GetSettingsObject();
        }

        private void saveSettings(string settingsFilePath)
        {
            JacekMatulewski.Settings.SettingsManager<GameSettings> sm = new JacekMatulewski.Settings.SettingsManager<GameSettings>(settings, JacekMatulewski.Settings.StoringMethod.XmlFile, settingsFilePath);
            sm.Save();
        }
        */

        public MainWindow()
        {
            _c = new KonfGry();

            InitializeComponent();

            //ominięcie babola Windows
            double width = SystemParameters.WorkArea.Width + SystemParameters.FixedFrameVerticalBorderWidth;
            double height = SystemParameters.WorkArea.Height + SystemParameters.FixedFrameHorizontalBorderHeight;
            this.Width = (int)width;
            this.Height = (int)height;

            //GameLab.Geometry.Size canvasSize = new GameLab.Geometry.Size((int)canvas.ActualWidth, (int)canvas.Height);
            Geometry.Size canvasSize = new Geometry.Size(800, 600);
            _c._BPX = canvasSize.Width / 2;
            _c._BPY = canvasSize.Height - 10 * _c._PSH;
            _c._PPX = canvasSize.Width / 2;
            _c._PPY = canvasSize.Height - 4 * _c._PSH;            

            gra = new Gra(_c, canvasSize);
            gra.Moved += model_PaddleMoved;
            gra.BMoved += model_BallMoved;
            gra.BrickStateChanged += model_BrickStateChanged;
            gra.LevelChanged += model_LevelChanged;

            createOrAdjustBricks();
            paddle.Width = gra.P.Width;
            paddle.Height = gra.P.Height;
            adjustPaddlePosition();
            ball.Width = gra.Rect.Width;
            ball.Height = gra.Rect.Height;
            adjustBallPosition();

            dispatcherTimer = new System.Windows.Threading.DispatcherTimer();
            dispatcherTimer.Tick += dispatcherTimer_Tick;
            dispatcherTimer.Interval = new TimeSpan(0, 0, 0, 0, _c.TimerIntervalMs);
            dispatcherTimer.Start();

            originalCursor = Cursor;
            Cursor = Cursors.None;
        }        

        private void model_PaddleMoved(object sender, EventArgs e)
        {
            adjustPaddlePosition();
        }

        private void model_BallMoved(object sender, EventArgs e)
        {
            adjustBallPosition();
        }

        private void model_BrickStateChanged(object sender, Gra.BrickStateEventArgs e)
        {
            switch (e.NewState)
            {
                case Gra.State.Normal:
                    break;
                case Gra.State.Crushed:
                    bricks[e.Ix, e.Iy].Stroke = bricks[e.Ix, e.Iy].Fill;
                    break;
                case Gra.State.Removed:
                    bricks[e.Ix, e.Iy].Stroke = Brushes.Transparent;
                    bricks[e.Ix, e.Iy].Fill = Brushes.Transparent;
                    break;
            }
        }

        private void model_LevelChanged(object sender, int e)
        {
            dispatcherTimer.Stop();
            messages.Text = "Następny poziom";
            messages.Visibility = Visibility.Visible;
            ball.Visibility = Visibility.Hidden;

            System.Windows.Threading.DispatcherTimer pauseTimer = new System.Windows.Threading.DispatcherTimer();
            pauseTimer.Tick += 
                (object _sender, EventArgs _e) =>
                {
                    pauseTimer.Stop();
                    messages.Visibility = Visibility.Hidden;
                    ball.Visibility = Visibility.Visible;
                    dispatcherTimer.Start();
                    createOrAdjustBricks(true);
                    adjustPaddlePosition();
                    adjustBallPosition();
                };
            pauseTimer.Interval = new TimeSpan(0, 0, 0, 2, 0); //2s
            pauseTimer.Start();          
        }

        private long timeMs;
        private bool tickExecuting = false;

        private void dispatcherTimer_Tick(object sender, EventArgs e)
        {
            if (tickExecuting) return;
            tickExecuting = true;

            timeMs += _c.TimerIntervalMs;

            //ballPositionY = 293 + (int)(100 * Math.Sin(0.05 * time));
            //ball.Margin = new Thickness(172, ballPositionY, 0, 0);

            if (_c.GameControlMode == KonfGry._GameControlMode.Keyboard)
            {
                if (IsKeyDown(Key.A) || IsKeyDown(Key.Left)) gra.MPHor(Gra.Direction.Left);
                if (IsKeyDown(Key.D) || IsKeyDown(Key.Right)) gra.MPHor(Gra.Direction.Right);
            }

            gra.Update(timeMs); //czy nie przenieść timera do modelu i działać na zdarzeniach?
            text.Text = "Poziom: " + gra.l.ToString() + ", Punkty: " + gra.p.ToString();

            tickExecuting = false;
        }

        //view
        private System.Windows.Shapes.Rectangle[,] bricks = null;

        private Brush getBrushForRow(int iy)
        {
            switch(iy)
            {
                case 0: return Brushes.Red;
                case 1: return Brushes.Orange;
                case 2: return Brushes.Yellow;
                case 3: return Brushes.Green;
                case 4: return Brushes.Cyan;
                case 5: return Brushes.Indigo;
                case 6: return Brushes.Violet;
                default: return Brushes.White;
            }
        }

        private void createOrAdjustBricks(bool reset = false)
        {            
            int nx = gra.rects.GetLength(0);
            int ny = gra.rects.GetLength(1);
            if (reset) bricks = null;
            if (bricks == null) bricks = new WPFShapes.Rectangle[nx, ny];
            for (int iy = 0; iy < ny; ++iy)
            {
                for (int ix = 0; ix < nx; ++ix)
                {
                    Rectangle brickShape = gra.rects[ix, iy];
                    WPFShapes.Rectangle r;
                    if (bricks[ix, iy] == null)
                    {
                        r = new WPFShapes.Rectangle();
                        r.Fill = getBrushForRow(iy);
                        r.Stroke = Brushes.White;
                        r.StrokeThickness = 3;
                        bricks[ix, iy] = r;
                        canvas.Children.Add(r);
                    }
                    else r = bricks[ix, iy];

                    r.Width = brickShape.Width;
                    r.Height = brickShape.Height;
                    Canvas.SetLeft(r, brickShape.Left);
                    Canvas.SetTop(r, brickShape.Top);  
                }
            }
        }

        private void adjustPaddlePosition()
        {
            Canvas.SetLeft(paddle, gra.P.Left);
            Canvas.SetTop(paddle, gra.P.Top);            
        }

        private void adjustBallPosition()
        {
            Canvas.SetLeft(ball, gra.Rect.Left);
            Canvas.SetTop(ball, gra.Rect.Top);
        }

        private void Window_SizeChanged(object sender, SizeChangedEventArgs e)
        {
            double width = SystemParameters.WorkArea.Width + SystemParameters.FixedFrameVerticalBorderWidth;
            double height = SystemParameters.WorkArea.Height + SystemParameters.FixedFrameHorizontalBorderHeight;
            this.Width = (int)width;
            this.Height = (int)height;

            //GameLab.Geometry.Size screenSize = new GameLab.Geometry.Size((int)ActualWidth, (int)ActualHeight);
            //GameLab.Geometry.Size screenSize = new GameLab.Geometry.Size((int)Width, (int)Height);
            //GameLab.Geometry.Size screenSize = new GameLab.Geometry.Size((int)SystemParameters.PrimaryScreenWidth, (int)SystemParameters.PrimaryScreenHeight);
            //GameLab.Geometry.Size screenSize = new GameLab.Geometry.Size((int)e.NewSize.Width, (int)e.NewSize.Height);
            //TODO: powtórzenie kodu !!!!!!!!!!!!
            Geometry.Size canvasSize = new Geometry.Size((int)canvas.ActualWidth, (int)canvas.ActualHeight);
            _c._BPX = canvasSize.Width / 4;
            _c._BPY = canvasSize.Height - 10 * _c._PSH;
            _c._PPX = canvasSize.Width / 2;
            _c._PPY = canvasSize.Height - 4 * _c._PSH;            

            /*
            //TEST
            settings.InitialPaddlePositionX -= 20;
            //settings.InitialBallPositionX -= 40;
            settings.InitialBallPositionX -= 55;
            settings.InitialBallVelocityY = -1;
            */

            gra.dopDoRozm(canvasSize);
            createOrAdjustBricks();
            adjustPaddlePosition();
            adjustBallPosition();

            //settings.InitialBallVelocityY = -settings.InitialBallVelocityY;
        }

        private void Window_MouseMove(object sender, MouseEventArgs e)
        {
            if (_c.GameControlMode == KonfGry._GameControlMode.Mouse)
            {
                int x = (int)e.GetPosition(this).X - gra.P.Width / 2;
                gra.SetPP(x);
                //adjustPaddle();
            }
        }

        private void Window_Closed(object sender, EventArgs e)
        {
            //Log.Save("test.log");
            this.Cursor = originalCursor;            
        }

        [Flags]
        private enum KeyStates
        {
            None = 0,
            Down = 1,
            Toggled = 2
        }

        [DllImport("user32.dll", CharSet = CharSet.Auto, ExactSpelling = true)]
        private static extern short GetKeyState(int keyCode);

        private static KeyStates GetKeyState(Key key)
        {
            KeyStates state = KeyStates.None;

            int keyCode = KeyInterop.VirtualKeyFromKey(key);
            short retVal = GetKeyState(keyCode);

            //If the high-order bit is 1, the key is down
            //otherwise, it is up.
            if ((retVal & 0x8000) == 0x8000)
                state |= KeyStates.Down;

            //If the low-order bit is 1, the key is toggled.
            if ((retVal & 1) == 1)
                state |= KeyStates.Toggled;

            return state;
        }

        public static bool IsKeyDown(Key key)
        {
            return KeyStates.Down == (GetKeyState(key) & KeyStates.Down);
        }

        public static bool IsKeyToggled(Key key)
        {
            return KeyStates.Toggled == (GetKeyState(key) & KeyStates.Toggled);
        }

        public class KonfGry
        {
            public enum _GameControlMode { Keyboard, Mouse, Eyetracker }
            public _GameControlMode GameControlMode = _GameControlMode.Mouse;

            public enum _PaddleControlMode { Direct, ConstantVelocity, ProportionalVelocity /*HarmonicForce*/ }
            public _PaddleControlMode PaddleControlMode = _PaddleControlMode.Direct;

            public int TimerIntervalMs = 10;

            public int BMX = 30;
            public int BSX = 20;
            public int BSY = 20;
            public int BSH = 40;

            public bool cr = true;

            public int N1 = 10;
            public int N2 = 1;

            public int Mn = 5;

            [NonSerialized] public int _BPX;
            [NonSerialized] public int _BPY;
            public int _BSW = 30;
            public int _BSH = 30;
            public float _BVX = 0.4f;
            public float _BVY = -0.6f;

            public float MBVX = 1.0f;

            [NonSerialized] public int _PPX;
            [NonSerialized] public int _PPY;
            public int _PSW = 150;
            public int _PSH = 30;

            public int PKMS = 10;
            public int PCV = 2;
            public double PPVC = 0.01;

            public bool POP = true;
        }
    }
}
