﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace GazeBreakoutWPF
{
    using GazeBreakoutWPF.Geometry;
    using static GazeBreakoutWPF.MainWindow;

    //tu nie ma odwraca (paletka u góry, dopiero na poziomie wyświetlania)
    public class Gra
    {
        public enum State { Removed, Crushed, Normal }

        public int p { get; private set; } = 0;
        public int l { get; private set; } = 1;

        private Point bp; //lewy górny róg
        private Size bs;

        private Point pp;
        private Size ps;

        private double pvx;

        public Rectangle Rect
        {
            get
            {
                return new Rectangle(bp, bs);
            }
        }

        public Rectangle P
        {
            get
            {
                return new Rectangle(pp, ps);
            }
        }

        public Rectangle[,] rects { get; private set; } = null;
        public State?[,] ss { get; private set; } = null;

        private Size canvasSize;
        private KonfGry ust;

        public Gra(KonfGry ust, Size canvasSize)
        {
            this.ust = ust;
            this.canvasSize = canvasSize;

            crB();
            brB2();
            crP();
        }

        private void crB(bool reset = false)
        {
            int nx = ust.N1;
            int ny = ust.N2;

            int sx = ust.BSX;
            int sy = ust.BSY;
            int sw = (canvasSize.Width - 2 * ust.BMX - (nx - 1) * sx) / nx;
            int sh = ust.BSH;

            int firstRawPositionY = canvasSize.Height / 2 - ny * sh - (ny - 1) * sy;

            if (reset)
            {
                rects = null;
                ss = null;
            }
            if (rects == null) rects = new Rectangle[nx, ny];
            if (ss == null) ss = new State?[nx, ny];
            for (int iy = 0; iy < ny; ++iy)
            {
                for (int ix = 0; ix < nx; ++ix)
                {
                    int x = ust.BMX + ix * (sw + sx);
                    int y = firstRawPositionY + iy * (sh + sy);
                    if (ss[ix, iy] == null)
                    {
                        State brickState = new State();
                        //brick.Rectangle = new Rectangle(x, y, brickSizeWidth, brickSizeHeight);
                        brickState = State.Normal;
                        ss[ix, iy] = brickState;
                    }
                    rects[ix, iy] = new Rectangle(x, y, sw, sh);
                }
            }
        }

        private void brB2()
        {
            this.bs = new Size(ust._BSW, ust._BSH);
            this.bp = new Point(ust._BPX, ust._BPY);
            this.bvx = ust._BVX;
            this.bvy = ust._BVY;
        }

        private void crP()
        {
            this.ps = new Size(ust._PSW, ust._PSH);
            this.pp = new Point(ust._PPX, ust._PPY);
        }

        public void dopDoRozm(Size newScreenSize)
        {
            canvasSize = newScreenSize;
            crB();
            brB2();
            crP();
        }

        public event EventHandler Moved;

        private void onMoved()
        {
            if (Moved != null) Moved(this, EventArgs.Empty);
        }

        public enum Direction { Left, Right }

        public void MPHor(Direction direction)
        {
            switch (direction)
            {
                case Direction.Left:
                    pp.X -= ust.PKMS;
                    limitPPX();
                    onMoved();
                    break;
                case Direction.Right:
                    pp.X += ust.PKMS;
                    limitPPX();
                    onMoved();
                    break;
            }
        }

        private int lasMouse;

        private void setPCV(int x)
        {
            if (x < pp.X) pvx = -ust.PCV;
            if (x > pp.X) pvx = ust.PCV;
            if (Math.Abs(x - pp.X) < ps.Width / 10) pvx = 0;
            //else onPaddleMoved(); //jest w Update, niepotrzebne
        }

        private void setPPV(int x)
        {
            if (Math.Abs(x - pp.X) < ps.Width / 10) pvx = 0;
            else pvx = ust.PPVC * (x - pp.X);
        }

        public void SetPP(int x)
        {
            lasMouse = x;
            switch (ust.PaddleControlMode)
            {
                case KonfGry._PaddleControlMode.Direct:
                    pp.X = x;
                    limitPPX();
                    onMoved();
                    break;
                case KonfGry._PaddleControlMode.ConstantVelocity:
                    setPCV(x);
                    break;
                case KonfGry._PaddleControlMode.ProportionalVelocity:
                    setPPV(x);
                    break;
            }
        }

        long prevTimeMs = 0;

        private void limitPPX()
        {
            if (pp.X < 0) pp.X = 0;
            if (pp.X + ps.Width > canvasSize.Width) pp.X = canvasSize.Width - ps.Width;
        }

        private void euler(double dt)
        {
            pp.X += (int)(pvx * dt);
            limitPPX();
        }

        public void Update(long timeMs)
        {
            double dt = timeMs - prevTimeMs;

            switch (ust.PaddleControlMode)
            {
                case KonfGry._PaddleControlMode.ConstantVelocity:
                    if (pvx != 0)
                    {
                        euler(dt);
                        setPCV(lasMouse);
                        onMoved();
                    }
                    break;
                case KonfGry._PaddleControlMode.ProportionalVelocity:
                    if (pvx != 0)
                    {
                        euler(dt);
                        setPPV(lasMouse);
                        onMoved();
                    }
                    break;
            }

            bEuler(dt);

            if (NRem == 0) raise();

            prevTimeMs = timeMs;
        }

        private double bvx, bvy;
        private Point pbp;

        private void bEuler(double dt)
        {
            bp.X += (int)(bvx * dt);
            bp.Y += (int)(bvy * dt);
            beb();
            bpb();
            bbb();            
            onBMoved();
            pbp = bp;
        }

        public int NRem
        {
            get
            {
                int n = 0;
                foreach (State brickState in ss)
                    if (brickState != State.Removed) n++;
                return n;
            }
        }

        public int NRmv
        {
            get
            {
                int n = 0;
                foreach (State brickState in ss)
                    if (brickState == State.Removed) n++;
                return n;
            }
        }

        private void beb()
        {
            if (bp.X < 0)
            {
                bvx = -bvx;
                //ballPosition.X = -ballPosition.X; odbicie z odpowiednią drogą
                bp.X = 0; //wyrównanie, żeby było widać moment zderzenia
                //Log.Add("Left edge hit by ball");
            }
            if (bp.X + bs.Width > canvasSize.Width)
            {
                bvx = -bvx;
                //ballPosition.X = canvasSize.Width - ballSize.Width - (ballPosition.X - canvasSize.Width + ballSize.Width);
                bp.X = canvasSize.Width - bs.Width;
                //Log.Add("Right edge hit by ball");
            }
            if (bp.Y < 0)
            {
                bvy = -bvy;
                //ballPosition.Y = -ballPosition.Y;
                bp.Y = 0;
                //Log.Add("Top edge hit by ball");
            }
            //tu wykrycie przegranej - opcja
            if (bp.Y + bs.Height > canvasSize.Height)
            {
                bvy = -bvy;
                //ballPosition.Y = canvasSize.Height - ballSize.Height - (ballPosition.Y - canvasSize.Height + ballSize.Height);
                bp.Y = canvasSize.Height - bs.Height;
                //Log.Add("Bottom edge hit by ball"); //tu przegrana
            }
        }












        private bool colision(Point rectanglePosition, Size rectangleSize)
        {
            return
                bp.Y + bs.Height > rectanglePosition.Y &&
                bp.Y < rectanglePosition.Y + rectangleSize.Height &&
                bp.X + bs.Width > rectanglePosition.X &&
                bp.X < rectanglePosition.X + rectangleSize.Width;
        }

        //kulka jest rysowana jako okrągła, ale odbija się jakby była kwadratowa
        private bool bbr(Point rectanglePosition, Size rectangleSize, bool overridePhysics = false)
        {
            if (colision(rectanglePosition, rectangleSize))
            {
                Point? pi_left, pi_top, pi_right, pi_bottom;
                //bool bi_left = IsLineSegmentsIntersecting(new Point(prevBallPosition.X + ballSize.Width, prevBallPosition.Y), new Point(ballPosition.X + ballSize.Width, ballPosition.Y), rectanglePosition, new Point(rectanglePosition.X, rectanglePosition.Y + rectangleSize.Height), out pi_left);
                //bool bi_top = IsLineSegmentsIntersecting(new Point(prevBallPosition.X, prevBallPosition.Y + ballSize.Height), new Point(ballPosition.X, ballPosition.Y + ballSize.Height), rectanglePosition, new Point(rectanglePosition.X + rectangleSize.Width, rectanglePosition.Y), out pi_top);
                //bool bi_right = IsLineSegmentsIntersecting(prevBallPosition, ballPosition, new Point(rectanglePosition.X + rectangleSize.Width, rectanglePosition.Y), new Point(rectanglePosition.X + rectangleSize.Width, rectanglePosition.Y + rectangleSize.Height), out pi_right);
                //bool bi_bottom = IsLineSegmentsIntersecting(prevBallPosition, ballPosition, new Point(rectanglePosition.X, rectanglePosition.Y + rectangleSize.Height), new Point(rectanglePosition.X + rectangleSize.Width, rectanglePosition.Y + rectangleSize.Height), out pi_bottom);
                bool bi_left = isLineInter(new Point(pbp.X + bs.Width, pbp.Y), new Point(bp.X + bs.Width, bp.Y), rectanglePosition, new Point(rectanglePosition.X, rectanglePosition.Y + rectangleSize.Height), out pi_left);
                if(!bi_left) bi_left = isLineInter(new Point(pbp.X + bs.Width, pbp.Y + bs.Height), new Point(bp.X + bs.Width, bp.Y + bs.Height), rectanglePosition, new Point(rectanglePosition.X, rectanglePosition.Y + rectangleSize.Height), out pi_left);
                bool bi_top = isLineInter(new Point(pbp.X, pbp.Y + bs.Height), new Point(bp.X, bp.Y + bs.Height), rectanglePosition, new Point(rectanglePosition.X + rectangleSize.Width, rectanglePosition.Y), out pi_top);
                if(!bi_top) bi_top = isLineInter(new Point(pbp.X + bs.Width, pbp.Y + bs.Height), new Point(bp.X + bs.Width, bp.Y + bs.Height), rectanglePosition, new Point(rectanglePosition.X + rectangleSize.Width, rectanglePosition.Y), out pi_top);
                bool bi_right = isLineInter(pbp, bp, new Point(rectanglePosition.X + rectangleSize.Width, rectanglePosition.Y), new Point(rectanglePosition.X + rectangleSize.Width, rectanglePosition.Y + rectangleSize.Height), out pi_right);
                if(!bi_right) bi_right = isLineInter(new Point(pbp.X, pbp.Y + bs.Height), new Point(bp.X, bp.Y + bs.Height), new Point(rectanglePosition.X + rectangleSize.Width, rectanglePosition.Y), new Point(rectanglePosition.X + rectangleSize.Width, rectanglePosition.Y + rectangleSize.Height), out pi_right);
                bool bi_bottom = isLineInter(pbp, bp, new Point(rectanglePosition.X, rectanglePosition.Y + rectangleSize.Height), new Point(rectanglePosition.X + rectangleSize.Width, rectanglePosition.Y + rectangleSize.Height), out pi_bottom);
                if(!bi_bottom) bi_bottom = isLineInter(new Point(pbp.X + bs.Width, pbp.Y), new Point(bp.X + bs.Width, bp.Y), new Point(rectanglePosition.X, rectanglePosition.Y + rectangleSize.Height), new Point(rectanglePosition.X + rectangleSize.Width, rectanglePosition.Y + rectangleSize.Height), out pi_bottom);
                //szukam najbliższego punktu przecięcia
                double? di_left = null, di_top = null, di_right = null, di_bottom = null;

                List<double> di = new List<double>();
                if (pi_left.HasValue) { di_left = Distance(new Point(pbp.X + bs.Width, pbp.Y), pi_left.Value); di.Add(di_left.Value); }
                if (pi_top.HasValue) { di_top = Distance(new Point(pbp.X, pbp.Y + bs.Height), pi_top.Value); di.Add(di_top.Value); }
                if (pi_right.HasValue) { di_right = Distance(pbp, pi_right.Value); di.Add(di_right.Value); }
                if (pi_bottom.HasValue) { di_bottom = Distance(pbp, pi_bottom.Value); di.Add(di_bottom.Value); }

                if (di.Count > 0)
                {
                    double di_min = di.Min();
                    //Log.Add("Ball bounced by paddle");

                    if (di_left.HasValue && di_min == di_left)
                    {
                        bvx = -bvx;
                        bp.X = rectanglePosition.X - bs.Width - 1;
                    }
                    if (di_right.HasValue && di_min == di_right)
                    {
                        bvx = -bvx;
                        bp.X = rectanglePosition.X + rectangleSize.Width + 1;
                    }
                    if (di_top.HasValue && di_min == di_top)
                    {
                        bvy = -bvy;
                        if(overridePhysics && pi_top.HasValue)
                        {
                            double c = 2.0 * (bp.X + bs.Width / 2 - rectanglePosition.X) / rectangleSize.Width - 1.0;
                            bvx += c * 1.0;
                            if (bvx < -ust.MBVX) bvx = -ust.MBVX;
                            if (bvx > ust.MBVX) bvx = ust.MBVX;
                        }
                        bp.Y = rectanglePosition.Y - bs.Height - 1;
                    }
                    if (di_bottom.HasValue && di_min == di_bottom)
                    {
                        bvy = -bvy;
                        bp.Y = rectanglePosition.Y + rectangleSize.Height + 1;
                    }

                    return true;
                }
            }
            return false;
        }

        private bool brb(Rectangle rectangle)
        {
            return bbr(rectangle.Position, rectangle.Size);
        }

        private bool bpb()
        {
            return bbr(pp, ps, ust.POP);
        }

        public class BrickStateEventArgs : EventArgs
        {
            public int Ix, Iy;
            public State NewState;
        }

        public event EventHandler<BrickStateEventArgs> BrickStateChanged;

        private void onBrickStateChanged(int ix, int iy, State newState)
        {
            if (BrickStateChanged != null)
                BrickStateChanged(
                    this,
                    new BrickStateEventArgs() { Ix = ix, Iy = iy, NewState = newState }
                );
        }

        private void bbb()
        {
            int nx = ust.N1;
            int ny = ust.N2;

            for (int iy = 0; iy < ny; ++iy)
            {
                for (int ix = 0; ix < nx; ++ix)
                {                    
                    if (ss[ix, iy] != State.Removed)
                    {
                        if (brb(rects[ix, iy]))
                        {
                            p++;                            
                            if (ust.cr) ss[ix, iy]--;
                            else ss[ix, iy] = State.Removed;
                            //Log.Add("Brick hit by ball. Brick[" + ix + "," + iy + "] state changed to " + _BricksState[ix, iy].ToString());
                            onBrickStateChanged(ix, iy, ss[ix, iy].Value);                            
                        }
                    }
                }
            }
        }

        /*
        private void ballPaddleBounces()
        {            
            //trzeba sprawdzić którą ścianą paletki weszła
            if(isBallPaddleCollision())
            {
                Point? pi_left, pi_top, pi_right, pi_bottom;
                bool bi_left = IsLineSegmentsIntersecting(new Point(prevBallPosition.X + ballSize.Width, prevBallPosition.Y), new Point(ballPosition.X + ballSize.Width, ballPosition.Y), paddlePosition, new Point(paddlePosition.X, paddlePosition.Y + paddleSize.Height), out pi_left);
                bool bi_top = IsLineSegmentsIntersecting(new Point(prevBallPosition.X, prevBallPosition.Y + ballSize.Height), new Point(ballPosition.X, ballPosition.Y + ballSize.Height), paddlePosition, new Point(paddlePosition.X + paddleSize.Width, paddlePosition.Y), out pi_top);
                bool bi_right = IsLineSegmentsIntersecting(prevBallPosition, ballPosition, new Point(paddlePosition.X + paddleSize.Width, paddlePosition.Y), new Point(paddlePosition.X + paddleSize.Width, paddlePosition.Y + paddleSize.Height), out pi_right);
                bool bi_bottom = IsLineSegmentsIntersecting(prevBallPosition, ballPosition, new Point(paddlePosition.X, paddlePosition.Y + paddleSize.Height), new Point(paddlePosition.X + paddleSize.Width, paddlePosition.Y + paddleSize.Height), out pi_bottom);
                //szukam najbliższego punktu przecięcia
                double? di_left = null, di_top = null, di_right = null, di_bottom = null;

                List<double> di = new List<double>();
                if (pi_left.HasValue) { di_left = Distance(new Point(prevBallPosition.X + ballSize.Width, prevBallPosition.Y), pi_left.Value); di.Add(di_left.Value); }
                if (pi_top.HasValue) { di_top = Distance(new Point(prevBallPosition.X, prevBallPosition.Y + ballSize.Height), pi_top.Value); di.Add(di_top.Value); }
                if (pi_right.HasValue) { di_right = Distance(prevBallPosition, pi_right.Value); di.Add(di_right.Value); }
                if (pi_bottom.HasValue) { di_bottom = Distance(prevBallPosition, pi_bottom.Value); di.Add(di_bottom.Value); }

                if (di.Count > 0)
                {
                    double di_min = di.Min();

                    if (di_left.HasValue && di_min == di_left)
                    {
                        ballVelocityX = -ballVelocityX;
                        ballPosition.X = paddlePosition.X - ballSize.Width - 1;
                    }
                    if (di_right.HasValue && di_min == di_right)
                    {
                        ballVelocityX = -ballVelocityX;
                        ballPosition.X = paddlePosition.X + paddleSize.Width + 1;
                    }
                    if (di_top.HasValue && di_min == di_top)
                    {
                        ballVelocityY = -ballVelocityY;
                        ballPosition.Y = paddlePosition.Y - ballSize.Height - 1;
                    }
                    if (di_bottom.HasValue && di_min == di_bottom)
                    {
                        ballVelocityY = -ballVelocityY;
                        ballPosition.Y = paddlePosition.Y + paddleSize.Height + 1;
                    }
                }
            }
        }
        */

        public event EventHandler BMoved;

        private void onBMoved()
        {
            if (BMoved != null) BMoved(this, EventArgs.Empty);
        }

        public event EventHandler<int> LevelChanged;

        private void onLevelChanged()
        {
            if (LevelChanged != null) LevelChanged(this, ust.N2);
        }

        private void reset()
        {
            ss = null;
            rects = null;
        }

        private void raise()
        {
            l++;
            p += 10;

            ust.N2++;
            if(ust.N2 >= ust.Mn)
            {
                ust.N2 = 1;
                ust.cr = true;
            }

            crB(true);
            brB2();
            crP();

            onLevelChanged();
        }

        private bool isLineInter(Point p1, Point p2, Point p3, Point p4, out Point? p)
        {
            p = null;

            //odcinek 1: p1 -> p2
            //odcinek 2: p3 -> p4

            double Ax = p2.X - p1.X;
            double Bx = -(p4.X - p3.X);
            double Cx = p3.X - p1.X;
            double Ay = p2.Y - p1.Y;
            double By = -(p4.Y - p3.Y);
            double Cy = p3.Y - p1.Y;

            double detA = Ax * By - Bx * Ay;
            if (detA == 0)
            {
                return false; //sprzeczny lub nieoznaczony (czyli osobno trzeba przypadek równoległy)
                //użyć iloczynu skalarnego?
            }

            //wzory Cramera
            double tr = (Cx * By - Bx * Cy) / detA;
            double ts = (Ax * Cy - Cx * Ay) / detA;

            bool wynik = tr >= 0 && tr <= 1 && ts >= 0 && ts <= 1;

            if (wynik)
            {
                double px = p1.X + tr * Ax;
                double py = p1.Y + tr * Ay;
                p = new Point((int)px, (int)py);
            }

            return wynik;
        }

        public static double Distance(Point p1, Point p2)
        {
            double dx = p2.X - p1.X;
            double dy = p2.Y - p1.Y;
            return Math.Sqrt(dx * dx + dy * dy);
        }
    }

    public interface IShape
    {
        bool Contains(Point point);
        PointF Center { get; }
        Rectangle AxisAlignedBoundingBox { get; } //AABB
        //Polygon ConvecHull;
    }

    public struct Rectangle : IShape
    {
        public Point Position;
        public Size Size;

        public Rectangle(Point position, Size size)
        {
            this.Position = position;
            this.Size = size;
        }

        public Rectangle(int x, int y, int width, int height)
            : this(new Point(x, y), new Size(width, height))
        { }

        public int Left
        {
            get
            {
                return Position.X;
            }
        }

        public int Right
        {
            get
            {
                return Position.X + Size.Width - 1; //po Position zajmuje już pierwszy piksel
            }
        }

        public int Width
        {
            get
            {
                return Size.Width;
            }
        }

        public int Top
        {
            get
            {
                return Position.Y;
            }
        }

        public int Bottom
        {
            get
            {
                return Position.Y + Size.Height - 1;
            }
        }

        public int Height
        {
            get
            {
                return Size.Height;
            }
        }

        public PointF Center
        {
            get
            {
                //return Position + Size / 2; //rounds to Point
                return new PointF(Position.X + (Size.Width - 1) / 2f, Position.Y + (Size.Height - 1) / 2f);
            }
        }

        public bool Contains(Point point)
        {
            return point.X >= Left && point.X < Right && point.Y >= Top && point.Y < Bottom;
            //TODO: Znaki większości dopasowane do tego, jak jest w Polygon. Nie powinno tak być.
        }

        public Rectangle AxisAlignedBoundingBox
        {
            get
            {
                return new Rectangle(Position, Size); //klon oryginalnego kształtu
            }
        }

        public Point[] Verticies
        {
            get
            {
                return new Point[4]
                {
                    new Point(Left,Top),
                    new Point(Right,Top),
                    new Point(Right,Bottom),
                    new Point(Left,Bottom)
                };
            }
        }

        public override string ToString()
        {
            return "Left = " + Left + ", Top = " + Top + ", Width = " + Width + ", Height = " + Height;
        }
    }

    public struct Ellipse : IShape
    {
        private Rectangle rectangle;

        public Ellipse(Rectangle area)
        {
            this.rectangle = area;
        }

        public Ellipse(Point position, Size size)
            : this(new Rectangle(position, size))
        { }

        public Ellipse(int x, int y, int width, int height)
            : this(new Point(x, y), new Size(width, height))
        { }

        //to wywali wyjątki, jeżeli użyty będzie konstruktor domyślny
        public Point Position { get { return rectangle.Position; } }
        public Size Size { get { return rectangle.Size; } }
        public int Left { get { return rectangle.Left; } }
        public int Right { get { return rectangle.Right; } }
        public int Width { get { return rectangle.Width; } }
        public int Top { get { return rectangle.Top; } }
        public int Bottom { get { return rectangle.Bottom; } }
        public int Height { get { return rectangle.Height; } }
        public PointF Center { get { return rectangle.Center; } }

        public bool Contains(Point point)
        {
            double semiAxisX = rectangle.Size.Width / 2f;
            double semiAxisY = rectangle.Size.Height / 2f;
            double dx = Center.X - point.X;
            double dy = Center.Y - point.Y;
            return (dx * dx / (semiAxisX * semiAxisX) + dy * dy / (semiAxisY * semiAxisY)) <= 1;
        }

        public Rectangle AxisAlignedBoundingBox
        {
            get
            {
                return new Rectangle(Position, Size); //klon oryginalnego kształtu
            }
        }
    }

    public struct Polygon : IShape
    {
        public Point[] Verticies;

        public Polygon(params Point[] verticies)
        {
            Verticies = new Point[verticies.Length];
            //if(verticies.Length>2) throw new GameLabException("Triangle should have three verticies specified");
            for (int i = 0; i < verticies.Length; ++i) this.Verticies[i] = verticies[i];
        }

        public PointF Center
        {
            get
            {
                PointF center = PointF.Zero;
                foreach (Point vertex in Verticies) center += (PointF)vertex;
                center /= Verticies.Length;
                return center;
            }
        }

        public bool Contains(Point point)
        {
            //http://dominoc925.blogspot.com/2012/02/c-code-snippet-to-determine-if-point-is.html
            //chyba metoda ray casting zob. https://en.wikipedia.org/wiki/Point_in_polygon
            bool contains = false;
            for (int i = 0, j = Verticies.Length - 1; i < Verticies.Length; j = i++)
            {
                if (((Verticies[i].Y > point.Y) != (Verticies[j].Y > point.Y)) && (point.X < (Verticies[j].X - Verticies[i].X) * (point.Y - Verticies[i].Y) / (Verticies[j].Y - Verticies[i].Y) + Verticies[i].X))
                {
                    contains = !contains;
                }
            }
            return contains;
        }

        public static Rectangle CalculateAxisAlignedBoundingBox(Point[] verticies)
        {
            Point min = verticies[0], max = verticies[0];
            for (int i = 1; i < verticies.Length; ++i)
            {
                if (verticies[i].X < min.X) min.X = verticies[i].X;
                if (verticies[i].Y < min.Y) min.Y = verticies[i].Y;
                if (verticies[i].X > max.X) max.X = verticies[i].X;
                if (verticies[i].Y > max.Y) max.Y = verticies[i].Y;
            }
            Size size = new Size(max.X - min.X, max.Y - min.Y);
            return new Rectangle(min, size);
        }

        //werteksy mogą być zmieniane, więc liczone za każdym razem
        public Rectangle AxisAlignedBoundingBox
        {
            get
            {
                return CalculateAxisAlignedBoundingBox(Verticies);
            }
        }
    }

    //zasadniczo to nie jest potrzebne skoro jest Polygon
    //nie może dziedziczyć z Polygon bo struktury
    public struct Triangle : IShape
    {
        public Point[] Verticies;

        public Triangle(params Point[] verticies)
        {
            Verticies = new Point[3];
            if (verticies.Length != 3) throw new Exception("Triangle should have three verticies specified");
            //może warto sprawdzić niewspółliniowość, żeby wykluczyć trójkąty bez pola
            for (int i = 0; i < 3; ++i) this.Verticies[i] = verticies[i];
        }

        public PointF Center
        {
            get
            {
                PointF center = PointF.Zero;
                foreach (Point vertex in Verticies) center += (PointF)vertex;
                return center;
            }
        }

        public double[] GetBaricentricCoordinates(Point point)
        {
            //współrzędne barycentyczne
            //http://fizyka.umk.pl/~jacek/dydaktyka/modsym/notatki/przeciecie_odcinka_z_trojkatem.pdf
            Point t1 = Verticies[0];
            Point t2 = Verticies[1];
            Point t3 = Verticies[2];
            Point w = point - t1;
            Point u = t2 - t1;
            Point v = t3 - t1;
            double uu = u.X * u.X + u.Y * u.Y;
            double vv = v.X * v.X + v.Y * v.Y;
            double uv = u.X * v.X + u.Y * v.Y;
            double wu = w.X * u.X + w.Y * u.Y;
            double wv = w.X * v.X + w.Y * v.Y;
            double denominator = vv * uu + uv * uv;
            double mu3 = (wv * uu + wu * uv) / denominator;
            double mu2 = (wu * vv + wv * uv) / denominator;
            double mu1 = 1 - mu2 - mu3;
            return new double[] { mu1, mu2, mu3 };
        }

        public bool Contains(Point point)
        {
            double[] baricentricCoordinates = GetBaricentricCoordinates(point);
            bool contains = true;
            foreach (double baricentricCoordinate in baricentricCoordinates)
                contains = contains && (baricentricCoordinate >= 0.0 && baricentricCoordinate <= 1.0);
            return contains;
        }

        public Rectangle AxisAlignedBoundingBox
        {
            get
            {
                return Polygon.CalculateAxisAlignedBoundingBox(Verticies);
            }
        }
    }
}
