﻿namespace MetodaSzablonowa
{
    public abstract class Pizza
    {
        private void przygotuj()
        {
            przygotujCiasto();
            dodajSos();
            połóżDodatki();
            dodajPrzyprawy();
            upiecz();
        }

        public Pizza()
        {
            przygotuj();
        }

        protected abstract void przygotujCiasto();

        private void dodajSosPomidorowy()
        {
            Console.WriteLine("Dodaję sos pomidorowy");
        }

        protected virtual void dodajSos()
        {
            dodajSosPomidorowy();
        }

        protected abstract void połóżDodatki();
        protected abstract void dodajPrzyprawy();

        protected virtual void upiecz()
        {
            Console.WriteLine("Pieczę przez 15 minut");
        }
    }

    public class PizzaMargeritha : Pizza
    {
        protected override void przygotujCiasto()
        {
            Console.WriteLine("Przygotowuję cieńkie ciasto");
        }

        protected override void połóżDodatki()
        {
            Console.WriteLine("Dodaję ser mozarella");
        }

        protected override void dodajPrzyprawy()
        {
            Console.WriteLine("Dodaję bazylę i odrobinę oliwa");
        }
    }

    public class PizzaSycylijska : Pizza
    {
        protected override void przygotujCiasto()
        {
            Console.WriteLine("Przygotuj grube ciasto");
        }

        protected override void połóżDodatki()
        {
            Console.WriteLine("Dodaję oliwki i kapary");
        }

        protected override void dodajPrzyprawy()
        {
            Console.WriteLine("Dodaję specjalną mieszankę przypraw");
        }

        protected override void upiecz()
        {
            Console.WriteLine("Pieczę przez 20 minut");
        }
    }


    internal class Program
    {
        static void Main(string[] args)
        {
            Pizza pm = new PizzaMargeritha();
            Pizza ps = new PizzaSycylijska();
        }
    }
}
