﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Pełnomocnik
{
    class Program
    {
        public static class SystemBankowy
        {
            public static void WpłaćNaKonto(ulong numerKonta, decimal kwota)
            {
                Console.WriteLine($"Wpłacono {kwota} zł na konto nr {numerKonta}");
            }

            public static void WypłaćZKonta(ulong numerKonta, decimal kwota)
            {
                Console.WriteLine($"Wypłacono {kwota} zł z konta nr {numerKonta}");
            }

            public class Przelew //POCO, DTO
            {
                public bool OperacjaWykonana = false;

                public decimal Kwota { get; private set; }
                public ulong NumerKontaNadawcy { get; private set; }
                public ulong NumerKontaOdbiorcy { get; private set; }

                public Przelew(ulong numerKontaNadawcy, ulong numerKontaOdbiorcy, decimal kwota)
                {
                    this.NumerKontaNadawcy = numerKontaNadawcy;
                    this.NumerKontaOdbiorcy = numerKontaOdbiorcy;
                    this.Kwota = kwota;
                }

                public void WykonajPrzelew()
                {
                    if (OperacjaWykonana)
                    {
                        Console.WriteLine("Przelew został już wykonany");
                        return;
                    }
                    SystemBankowy.WypłaćZKonta(NumerKontaNadawcy, Kwota);
                    SystemBankowy.WpłaćNaKonto(NumerKontaOdbiorcy, Kwota);
                    OperacjaWykonana = true;
                }
            }
        }


        static void Main(string[] args)
        {
            SystemBankowy.Przelew przelew1 = new SystemBankowy.Przelew(1, 2, 100.5M);
            SystemBankowy.Przelew przelew2 = new SystemBankowy.Przelew(2, 1, 53M);

            przelew1.WykonajPrzelew();
            przelew2.WykonajPrzelew();
            przelew1.WykonajPrzelew();
        }
    }
}
