﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Singleton10
{
    class Program
    {
        #region Klient
        class Klasa
        {
            public void Metoda()
            {
                Log log = Log.PobierzInstancję();
                log.Dodaj("2");
            }
        }

        static void Main(string[] args)
        {
            Log log = Log.PobierzInstancję();
            log.Dodaj("1");
            new Klasa().Metoda();
            log.Dodaj("3");
            log.Zapisz();
        }
        #endregion

        class Log
        {
            #region Singleton
            private Log() { }

            private static Log instancja = null;
            //TODO: dublet

            public static Log PobierzInstancję()
            {
                if (instancja == null) instancja = new Log();
                return instancja;
            }
            #endregion

            private static IFormatProvider fp = new System.Globalization.CultureInfo("pl-PL");
            private static string ścieżka = System.IO.Path.Combine(System.Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments), "log.txt");

            private List<string> komunikaty = new List<string>();

            public void Dodaj(string komunikat)
            {
                komunikaty.Add(DateTime.Now.ToString(fp) + ": " + komunikat);
            }

            public void Zapisz()
            {
                System.IO.File.WriteAllLines(ścieżka, komunikaty);
            }
        }
    }
}
