﻿using System;

namespace UMK.WzorceOperacyjne
{
    //https://sourcemaking.com/design_patterns/observer/cpp/1

    class WartośćZmienionaEventArgs : EventArgs
    {
        public int Wartość;
    }

    delegate void WartośćZmienionaEventHandler(object sender, WartośćZmienionaEventArgs e);    

    /*
    interface IObserwator
    {
        void Aktualizuj(object sender, WartośćZmienionaEventArgs e);
    }
    */

    class Dzielenie //: IObserwator
    {
        private int wartość = 0;
        private int dzielnik;

        public Dzielenie(int dzielnik)
        {
            this.dzielnik = dzielnik;
        }

        public void Aktualizuj(object sender, WartośćZmienionaEventArgs e)
        {
            int dzielna = e.Wartość;
            wartość = dzielna / dzielnik;
            Console.WriteLine("{0} / {1} = {2}", dzielna, dzielnik, wartość);
        }
    }

    class Modulo //: IObserwator
    {
        private int wartość = 0;
        private int dzielnik;

        public Modulo(int dzielnik)
        {
            this.dzielnik = dzielnik;
        }

        public void Aktualizuj(object sender, WartośćZmienionaEventArgs e)
        {
            int dzielna = e.Wartość;
            wartość = dzielna % dzielnik;
            Console.WriteLine("{0} % {1} = {2}", dzielna, dzielnik, wartość);
        }
    }

    class Podmiot
    {
        private int wartość;
        //private List<IObserwator> obserwatorzy = new List<IObserwator>();
        //private Dzielenie dzielenie; //obiekty, których stan zależy od zmieniającego się pola wartość
        //private Modulo modulo;

        public event WartośćZmienionaEventHandler WartośćZmieniona;

        private void powiadom()
        {
            //dzielenie.Aktualizuj(wartość);
            //modulo.Aktualizuj(wartość);
            //foreach (IObserwator obserwator in obserwatorzy) obserwator.Aktualizuj(wartość);
            if(WartośćZmieniona != null) 
                WartośćZmieniona(
                    this, 
                    new WartośćZmienionaEventArgs() { Wartość = wartość }
                    );
        }

        public Podmiot()
        {
            wartość = 0;
            //dzielenie = new Dzielenie(3);
            //modulo = new Modulo(3);
        }

        /*
        public void DodajObserwatorów(params IObserwator[] obserwatorzy)
        {
            this.obserwatorzy.AddRange(obserwatorzy);
        }

        public void UsuńObserwatorów(params IObserwator[] obserwatorzy)
        {
            foreach(IObserwator obserwator in obserwatorzy)
                this.obserwatorzy.Remove(obserwator);            
        }
        */

        public void ZmieńWartość(int nowaWartość)
        {
            wartość = nowaWartość;
            powiadom();
        }
    }
}