﻿using System;

namespace UMK.WzorceOperacyjne
{
    //https://sourcemaking.com/design_patterns/observer/cpp/1

    interface IObserwator
    {
        void Aktualizuj(int parametr);
    }

    class Dzielenie : IObserwator
    {
        private int wartość = 0;
        private int dzielnik;

        public Dzielenie(int dzielnik)
        {
            this.dzielnik = dzielnik;
        }

        public void Aktualizuj(int dzielna)
        {
            wartość = dzielna / dzielnik;
            Console.WriteLine("{0} / {1} = {2}", dzielna, dzielnik, wartość);
        }
    }

    class Modulo : IObserwator
    {
        private int wartość = 0;
        private int dzielnik;

        public Modulo(int dzielnik)
        {
            this.dzielnik = dzielnik;
        }

        public void Aktualizuj(int dzielna)
        {
            wartość = dzielna % dzielnik;
            Console.WriteLine("{0} % {1} = {2}", dzielna, dzielnik, wartość);
        }
    }

    class Podmiot
    {
        private int wartość;
        private List<IObserwator> obserwatorzy = new List<IObserwator>();
        //private Dzielenie dzielenie; //obiekty, których stan zależy od zmieniającego się pola wartość
        //private Modulo modulo;

        private void powiadom()
        {
            //dzielenie.Aktualizuj(wartość);
            //modulo.Aktualizuj(wartość);
            foreach (IObserwator obserwator in obserwatorzy)
                obserwator.Aktualizuj(wartość);
        }

        public Podmiot()
        {
            wartość = 0;
            //dzielenie = new Dzielenie(3);
            //modulo = new Modulo(3);
        }

        public void DodajObserwatorów(params IObserwator[] obserwatorzy)
        {
            this.obserwatorzy.AddRange(obserwatorzy);
        }

        public void UsuńObserwatorów(params IObserwator[] obserwatorzy)
        {
            foreach(IObserwator obserwator in obserwatorzy)
                this.obserwatorzy.Remove(obserwator);            
        }

        public void ZmieńWartość(int nowaWartość)
        {
            wartość = nowaWartość;
            powiadom();
        }
    }
}