﻿using System;

namespace UMK.WzorceStrukturalne
{
    //component
    abstract class Napój
    {
        public abstract decimal Cena();
        public void Objętość() //funckja nie podlegająca zmianom podczas dekoracji
        {
            Console.WriteLine("\nObjetosc: 330 ml");
        }
    }

    //concrete components
    class Herbata : Napój
    {
        public override decimal Cena()
        {
            return 6.70M;
        }

        public override string ToString()
        {
            return "Herbata";
        }
    }

    class Kawa : Napój
    {
        public override decimal Cena()
        {
            return 7.90M;
        }

        public override string ToString()
        {
            return "Kawa";
        }
    }

    //dekorator
    abstract class NapójZDodatkiem : Napój
    {
        protected Napój napój;

        public NapójZDodatkiem(Napój napój)
        {
            this.napój = napój;
        }

    }

    //concrete dekorator
    class NapójZeSzczyptąCynamonu : NapójZDodatkiem
    {
        public NapójZeSzczyptąCynamonu(Napój napój)
            : base(napój)
        { }

        public override decimal Cena()
        {
            return napój.Cena() + 0.5M;
        }

        public override string ToString()
        {
            return napój.ToString() + " ze szczyptą cynamonu";
        }
    }

    class NapójZCukrem : NapójZDodatkiem
    {
        private int liczbaŁyżeczek;

        public NapójZCukrem(Napój napój, int liczbaŁyżeczek = 1)
            : base(napój)
        {
            this.liczbaŁyżeczek = liczbaŁyżeczek;
        }

        public override decimal Cena()
        {
            return napój.Cena() + liczbaŁyżeczek * 1M;
        }

        public override string ToString()
        {
            return napój.ToString() + $" z łyżeczkami cukru ({liczbaŁyżeczek})";
        }
    }

    class NapójZPlastramiCytryny : NapójZDodatkiem
    {
        private int liczbaPlastrów;

        public NapójZPlastramiCytryny(Napój napój, int liczbaPlastrów = 1)
            : base(napój)
        {
            this.liczbaPlastrów = liczbaPlastrów;
        }

        public override decimal Cena()
        {
            return napój.Cena() + liczbaPlastrów* 3M;
        }

        public override string ToString()
        {
            return napój.ToString() + $" z plastrami cytryny ({liczbaPlastrów})";
        }
    }
}
