﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SingletonUMK
{
    class Program
    {
        class Klasa
        {
            public void Metoda()
            {
                Log.PobierzInstancję().Dodaj("2");
            }
        }

        static void Main(string[] args)
        {
            Log log = Log.PobierzInstancję();
            log.Dodaj("1");
            new Klasa().Metoda();
            log.Dodaj("3");
            Log.Zapisz();
        }

        private sealed class Log
        {
            #region Singleton
            private static Log instancja1 = null;
            private static Log instancja2 = null;

            private static Log bieżącaInstancja = null;

            private Log()
            {
            }

            public static Log PobierzInstancję()
            {
                if (instancja1 == null) { instancja1 = new Log(); bieżącaInstancja = instancja1; }
                else if (instancja2 == null) { instancja2 = new Log(); bieżącaInstancja = instancja2; }                
                return bieżącaInstancja;
                if (bieżącaInstancja == instancja1) bieżącaInstancja = instancja2; else bieżącaInstancja = instancja1;
            }
            #endregion

            #region Log
            private static IFormatProvider fp = new System.Globalization.CultureInfo("pl-PL");            
            private static string ścieżkaLog = System.IO.Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.UserProfile), "log.txt");

            private List<string> komunikaty = new List<string>();

            public void Dodaj(string komunikat)
            {
                komunikaty.Add(DateTime.Now.ToString(fp) + ": " + komunikat);
            }

            public static void Zapisz()
            {
                List<string> połączoneKomunikaty = new List<string>();
                połączoneKomunikaty.AddRange(instancja1.komunikaty);
                połączoneKomunikaty.AddRange(instancja2.komunikaty);
                //sortowanie
                System.IO.File.WriteAllLines(ścieżkaLog, połączoneKomunikaty);
            }
            #endregion
        }
    }
}
