﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SingletonUMK
{
    class Program
    {
        class Klasa
        {
            public void Metoda()
            {
                Log.PobierzInstancję().Dodaj("2");
            }
        }

        static void Main(string[] args)
        {
            Log log = Log.PobierzInstancję();
            log.Dodaj("1");
            new Klasa().Metoda();
            log.Dodaj("3");
            log.Zapisz();
        }

        private sealed class Log
        {
            #region Singleton
            private static Log instancja = null; //TODO: leniwa inicjacja

            private Log()
            {
            }

            public static Log PobierzInstancję()
            {
                if (instancja == null) instancja = new Log();
                return instancja;
            }
            #endregion

            #region Log
            private IFormatProvider fp = new System.Globalization.CultureInfo("pl-PL");            
            private string ścieżkaLog = System.IO.Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.UserProfile), "log.txt");

            private List<string> komunikaty = new List<string>();

            public void Dodaj(string komunikat)
            {
                komunikaty.Add(DateTime.Now.ToString(fp) + ": " + komunikat);
            }

            public void Zapisz()
            {
                System.IO.File.WriteAllLines(ścieżkaLog, komunikaty);
            }
            #endregion
        }
    }
}
