package helion.xc;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class GradientParametr extends Applet {
  private boolean isStandalone = false;
  float parKolor;
  //Get a parameter value
  public String getParameter(String key, String def) {
    return isStandalone ? System.getProperty(key, def) :
      (getParameter(key) != null ? getParameter(key) : def);
  }

  //Construct the applet
  public GradientParametr() {
  }
  //Initialize the applet
  public void init() {
    try {
      parKolor = Float.valueOf(this.getParameter("kolor", "0.0")).floatValue();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  //Component initialization
  private void jbInit() throws Exception {
  }
  //Get Applet information
  public String getAppletInfo() {
    return "Applet Information";
  }
  //Get parameter info
  public String[][] getParameterInfo() {
    String[][] pinfo =
      {
      {"kolor", "float", "Kolor"},
      };
    return pinfo;
  }

public void paint(Graphics g)
 {
 //float barwa=(float)Math.random();
 float barwa=parKolor;
 int wysokosc=this.getBounds().height;
 for(int indeks=0;indeks<wysokosc;indeks++)
     {
     float jasnosc=indeks/(float)(wysokosc-1);
     Color kolor=Color.getHSBColor(barwa,1,jasnosc);
     g.setColor(kolor);
     //g.setColor(Color.getHSBColor(barwa,1,indeks/(float)(wysokosc-1)));
     g.drawLine(0,indeks,this.getBounds().width,indeks);
     }
 }

}
