package helion.r6.beansexpress;

import java.beans.*;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class EdytorOkres extends PropertyEditorSupport {
  private static String[] resourceStrings = { "Bardzo dugi", "Dugi", "Normalny", "Krtki", "Bardzo krtki", };
  private static int[] intValues = { 2000, 1000, 500, 200, 100, };
  private static String[] sourceCodeStrings = { "2000", "1000", "500", "200", "100", };

  public EdytorOkres() {
  }
  public String[] getTags() {
    return resourceStrings;
  }
  public String getJavaInitializationString() {
    Object value = getValue();
    for (int i = 0; i < intValues.length; i++) {
      if (value.equals(new Integer(intValues[i]))) {
        return sourceCodeStrings[i];
      }
    }
    return null;
  }
  public String getAsText() {
    Object value = getValue();
    for (int i = 0; i < intValues.length; i++) {
      if (value.equals(new Integer(intValues[i]))) {
        return resourceStrings[i];
      }
    }
    return null;
  }
  public void setAsText(String text) throws IllegalArgumentException {
    for (int i = 0; i < resourceStrings.length; i++) {
      if (text.equals(resourceStrings[i])) {
        setValue(new Integer(intValues[i]));
        return;
      }
    }
    throw new IllegalArgumentException();
  }
}
