package helion.r6;

import java.awt.Image;
import java.beans.*;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class MigajacyPrzyciskBeanInfo extends SimpleBeanInfo {
  Class beanClass = MigajacyPrzycisk.class;
  String iconColor16x16Filename;
  String iconColor32x32Filename;
  String iconMono16x16Filename;
  String iconMono32x32Filename;

  public MigajacyPrzyciskBeanInfo() {
  }
  public PropertyDescriptor[] getPropertyDescriptors() {
    try {
      PropertyDescriptor _miganieWlaczone = new PropertyDescriptor("miganieWlaczone", beanClass, "getMiganieWlaczone", "setMiganieWlaczone");
      PropertyDescriptor _okres = new PropertyDescriptor("okres", beanClass, "getOkres", "setOkres");
      PropertyDescriptor _opoznienie = new PropertyDescriptor("opoznienie", beanClass, "getOpoznienie", "setOpoznienie");
      PropertyDescriptor[] pds = new PropertyDescriptor[] {
        _miganieWlaczone,
        _okres,
        _opoznienie};
      return pds;
    }
    catch(IntrospectionException ex) {
      ex.printStackTrace();
      return null;
    }
  }
  public java.awt.Image getIcon(int iconKind) {
    switch (iconKind) {
      case BeanInfo.ICON_COLOR_16x16:
        return iconColor16x16Filename != null ? loadImage(iconColor16x16Filename) : null;
      case BeanInfo.ICON_COLOR_32x32:
        return iconColor32x32Filename != null ? loadImage(iconColor32x32Filename) : null;
      case BeanInfo.ICON_MONO_16x16:
        return iconMono16x16Filename != null ? loadImage(iconMono16x16Filename) : null;
      case BeanInfo.ICON_MONO_32x32:
        return iconMono32x32Filename != null ? loadImage(iconMono32x32Filename) : null;
    }
    return null;
  }
}
